// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 22 1.5.1.4 source/core/collect/iqudil.h, collection, ioc.v400, 980918 
#ifndef _IQUDIL_
#define _IQUDIL_

#include <ilanglvl.hpp>
#include <iaqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGQueueAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGQueueAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGQueueAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueAsDilTableCursor
                            (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsDilTableCursor <Element, ElementOps>&
           operator=        (IGQueueAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGQueueAsDilTable :
  public IAQueue <Element> {
protected:

  typedef  IGQueueAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueAsDilTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGQueueAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGQueueAsDilTable
                            (INumber = 100);

           IGQueueAsDilTable
                            (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsDilTable <Element, ElementOps>&
           operator=        (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGQueueAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class IQueueAsDilTable :
  public IGQueueAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGQueueAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IQueueAsDilTable <Element> Self;

#define IQueueAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IQueueAsDilTable
                            (INumber = 100);

















protected:

           IQueueAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGQueueAsDilTable :
  public IGQueueAsDilTable
          <Element, ElementOps > {

  typedef  IVGQueueAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGQueueAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueAsDilTableTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGQueueAsDilTable
                            (INumber = 100);

















protected:

           IVGQueueAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVQueueAsDilTable :
  public IVGQueueAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGQueueAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVQueueAsDilTable <Element> Self;

#define IVQueueAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVQueueAsDilTable
                            (INumber = 100);

















protected:

           IVQueueAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iqudil.inl>


#pragma info (restore)


#endif // _IQUDIL_
