// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 20 1.5.1.4 source/core/collect/iqu.h, collection, ioc.v400, 980918 
#ifndef _IQU_
#define _IQU_

#include <ilanglvl.hpp>
#include <iaqu.h>
#include <iicseq.h>

#include <iivseq.h>

#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGQueue;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGQueueCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGQueue
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueCursor
                            (IGQueue
                              <
                               Element, ElementOps> const&);

  IGQueueCursor <Element, ElementOps>&
           operator=        (IGQueueCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGQueue :
  public IAQueue <Element> {
protected:

  typedef  IGQueue <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGQueueCursor
            <Element, ElementOps> Cursor;




           IGQueue
                            (INumber = 100);

           IGQueue
                            (IGQueue
                              <
                               Element, ElementOps> const&);

  IGQueue <Element, ElementOps>&
           operator=        (IGQueue
                              <
                               Element, ElementOps> const&);



















protected:

           IGQueue
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueue
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueCursor <Element, ElementOps>;






















};

template <class Element>
class IQueue :
  public IGQueue
          <Element, IStdOps <Element> > {

  typedef  IGQueue
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IQueue <Element> Self;

#define IQueueTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IQueue
                            (INumber = 100);

















protected:

           IQueue
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGQueue :
  public IGQueue
          <Element, ElementOps > {

  typedef  IVGQueue
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGQueue
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueTypedef (Element, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGQueue
                            (INumber = 100);

















protected:

           IVGQueue
                              (PureImplementation&);

private:












};

template <class Element>
class IVQueue :
  public IVGQueue
          <Element, IStdOps <Element> > {

  typedef  IVGQueue
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVQueue <Element> Self;

#define IVQueueTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVQueue
                            (INumber = 100);

















protected:

           IVQueue
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iqu.inl>


#pragma info (restore)


#endif // _IQU_
