// Revision: 28 1.8.1.5 source/ui/basectl/ipushbut.hpp, buttonctls, ioc.v400, 980918 
#ifndef _IPUSHBUT_
  #define _IPUSHBUT_
/*******************************************************************************
* FILE NAME: ipushbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPushButton                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibutton.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISize;
class IWindowHandle;
class IPushButtonData;

#pragma enum(4)
#pragma pack(push,4)

class IPushButton : public IButton  {
typedef IButton
  Inherited;
public:

class Style;

/*------------------------------- Constructors -------------------------------*/
  IPushButton ( unsigned long id,
                IWindow* parent,
                IWindow* owner,
                const IRectangle& initial= IRectangle(),
                const Style& style = defaultStyle() );

  IPushButton ( unsigned long id,
                IWindow*      parent );

  IPushButton ( const IWindowHandle& handle );

virtual
 ~IPushButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3( Style,
                         IPushButton,
                         IWindow,
                         IControl,
                         IButton );

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU help,
  IC_IMPORTU systemCommand,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU noBorder,
#endif
  IC_IMPORTU defaultButton;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*----------------------------- Style Functions ------------------------------*/
bool
  isDefault            ( ) const,
  isHelp               ( ) const,
#ifndef IC_WIN_FLAGNOP
  hasBorder            ( ) const,
#endif
  isSystemCommand      ( ) const;

virtual IPushButton
 &enableDefault        ( bool enable = true ),
 &disableDefault       ( ),
 &enableHelp           ( bool enable = true ),
 &disableHelp          ( ),
#ifndef IC_WIN_FLAGNOP
 &addBorder            ( bool add    = true ),
 &removeBorder         ( ),
#endif
 &enableSystemCommand  ( bool enable = true ),
 &disableSystemCommand ( );

/*-------------------------- Dialog Behavior Support -------------------------*/
bool
  hasEmphasis          ( ) const;
virtual IPushButton
 &addEmphasis          ( bool enable = true ),
 &removeEmphasis       ( );

protected:

/*-------------------------- Protected Constructors --------------------------*/
#ifdef IC_MOTIF
  IPushButton          ( );
#endif //IC_MOTIF

/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize      ( ) const;

/*---------------------- Event Handling Implementation -----------------------*/
#ifdef IC_MOTIFWIN
virtual bool
  passEventToOwner     ( IEvent &event );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

IPushButtonData
 *fPushButtonData;

#ifdef IC_MOTIF
friend void _System iPushButtonMotifCallback ( _WidgetRec *w,
                                               void       *client_data,
                                               void       *call_data );
#endif //IC_MOTIF

/*----------------------------- Hidden Functions -----------------------------*/
  IPushButton          ( const IPushButton& );
IPushButton
 &operator=            ( const IPushButton& );

};  // class IPushButton

INESTEDBITFLAGCLASSFUNCS ( Style, IPushButton )

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  // _IPUSHBUT_
