// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 18 1.6.1.3 source/core/collect/iptr.h, collection, ioc.v400, 980918 
#ifndef _IPTR_
#define _IPTR_

#include <iglobals.h>






#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)











#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

enum IExplicitInit
{
    IINIT
};

template <class Element>
class IElemPointer
{
public:

           IElemPointer     ();

           IElemPointer     (Element*, IExplicitInit = IINIT);

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element*
                            () const;
  friend
  Element& elementForOps
#if __IBMCPP__ >= 400
		<Element>
#endif
		(IElemPointer <Element>&);

  friend
  Element const&
           elementForOps
#if __IBMCPP__ >= 400
		<Element>
#endif
    		(IElemPointer <Element> const&) ;
protected:

private:

  Element* ivPtr;












};











template <class Element>
class IMngPointer {
public:

           IMngPointer      ();

           IMngPointer      (Element*, IExplicitInit);

           IMngPointer      (IMngPointer <Element> const&);

          ~IMngPointer      ();

  IMngPointer <Element>&
           operator=        (IMngPointer <Element> const&);

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element* () const;
















private:

  struct PtrRc
  { Element *ivPtr;

    unsigned int ivRc;

             PtrRc (Element *ptr)
             : ivPtr (ptr), ivRc (1)
             {
             }

            ~PtrRc ()
             { delete ivPtr; }

  } *ivPtrRc;














};

#if ! defined (__INO_STREAMING__)
template <class Element>
class IStreamablePointer {
public:

           IStreamablePointer      ();

           IStreamablePointer      (Element*, IExplicitInit);

           IStreamablePointer      (IStreamablePointer <Element> const&);

          ~IStreamablePointer      ();

  IStreamablePointer <Element>&
           operator=        (IStreamablePointer <Element> const&);

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element* () const;

private:

  struct PtrRc
  { Element *ivPtr;

    unsigned int ivRc;

             PtrRc (Element *ptr)
             : ivPtr (ptr), ivRc (1)
             {
             }

            ~PtrRc ()
             { delete ivPtr; }

  } *ivPtrRc;














};

class IDataStream;

template <class Element>
void operator<<=( IStreamablePointer<Element>&, IDataStream&);

template <class Element>
void operator>>=( const IStreamablePointer<Element>&, IDataStream&);
#endif











template <class Element>
class IMngElemPointer : protected IMngPointer <Element> {
public:

           IMngElemPointer  () ;

           IMngElemPointer  (Element*, IExplicitInit);

#if defined (ICLCC_COMPAT_PTR)
           IMngElemPointer  (Element const&);

           IMngElemPointer  (Element*);
#endif

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element*
                            () const;
  friend
  Element& elementForOps
#if __IBMCPP__ >= 400
		<Element>
#endif
		(IMngElemPointer <Element>&);

  friend
  Element const&
           elementForOps
#if __IBMCPP__ >= 400
		<Element>
#endif
		(IMngElemPointer <Element> const&);













protected:

private:











};















template <class Element>
class IAutoPointer {
public:

           IAutoPointer     ();

           IAutoPointer     (Element*, IExplicitInit);

           IAutoPointer     (IAutoPointer <Element> const&);

          ~IAutoPointer     ();

  void     operator=        (IAutoPointer <Element> const&);

           operator Element*
                            () const;

  Element& operator*        () const;

  Element* operator->       () const;

protected:

private:

  Element* ivPtr;













};











template <class Element>
class IAutoElemPointer : protected IAutoPointer <Element> {
public:

           IAutoElemPointer ();

           IAutoElemPointer (Element*, IExplicitInit);

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element*
                            () const;
  friend
  Element& elementForOps
#if __IBMCPP__ >= 400
		<Element>
#endif
		(IAutoElemPointer <Element>&);

  friend
  Element const&
           elementForOps
#if __IBMCPP__ >= 400
		<Element>
#endif
		(IAutoElemPointer <Element> const&);

protected:

private:











};











#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#include <iptr.inl>











#endif // _IPTR_
