// ----------------------------------------------------------------------------
// FILE NAME: iptarray.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IPointArray
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Material - Property of IBM
//   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved
//
// Revision: 62 1.5.1.3 source/core/base/iptarray.hpp, datatype, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IPTARRAY_
#define _IPTARRAY_

#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPoint;

#pragma pack(push,4)
#pragma enum(4)

class IPointArray
{
public:
    // ------------------------------- Constructors ---------------------------
    IPointArray(unsigned long dimension = 0, const IPoint* array = 0);
    IPointArray(const IPointArray& pointArray);
    ~IPointArray( );

    IPointArray& operator=(const IPointArray& pointArray);

    // --------------------------------- Data Access --------------------------
    unsigned long size() const;
    IPointArray& resize(unsigned long newsize);
    IPointArray& reverse();
    IPointArray reversed() const;
    IPointArray& insert(unsigned long index, const IPoint& point);
    IPointArray& add(const IPoint& point);
    IPointArray& remove(unsigned long index);

    IPoint& operator[](unsigned long index);
    const IPoint& operator[](unsigned long index) const;

    // ----------------------------- Comparisons ------------------------------
    bool operator==(const IPointArray& pointArray) const;
    bool operator!=(const IPointArray& pointArray) const;


private:
    // -------------------------------- Private -------------------------------
    IPoint* fPtArray;
    unsigned long fDim;

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
