// Revision: 49 1.5.1.3 source/ui/baseapp/iprofile.hpp, profile, ioc.v400, 980918  
#ifndef _IPROFILE_
#define _IPROFILE_
/*******************************************************************************
* FILE NAME: iprofile.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     iProfile                                                                 *
*     iProfile::Cursor                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IProfileData;
class IProfileCursorData;

#pragma enum(4)
#pragma pack(push,4)

class IProfile  {
public:
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IProfile  ( const char*      profileName );
  IProfile  ( const IProfile&  aProfile );

virtual
 ~IProfile  ( );

IProfile
 &operator= ( const IProfile&  aProfile );

/*----------------------------- Special Profiles -----------------------------*/
#ifndef IC_MOTIF_FLAGNOP
static IProfile
  systemProfile ( );

static IProfile
  userProfile   ( );
#endif   // IC_MOTIF

/*---------------------------- Profile Information ---------------------------*/
virtual IString
  name                 ( ) const,
  applicationOrKeyAt   ( const Cursor& cursor ) const;

#ifndef IC_WIN
virtual IProfileHandle
  handle               ( ) const;
#endif

virtual unsigned long
  numberOfKeys         ( const char*   applName = 0 ) const;

#ifndef IC_MOTIF_FLAGNOP
virtual unsigned long
  numberOfApplications ( ) const;
#endif  // IC_MOTIF_FLAGNOP


/*------------------------ Default Application Name --------------------------*/
virtual IString
  defaultApplicationName    ( ) const;

virtual IProfile
 &setDefaultApplicationName ( const char* applName );

/*------------------------ Reading and Writing Data --------------------------*/
virtual IString
  elementWithKey               ( const char* key,
                                 const char* applName = 0 );

virtual long
  integerWithKey               ( const char* key,
                                 const char* applName = 0 );

virtual IProfile
 &addOrReplaceElementWithKey   ( const char* key,
                                 const IString& data,
                                 const char* applName = 0 ),

 &addOrReplaceElementWithKey   ( const char* key,
                                 long        data,
                                 const char* applName = 0 );

virtual IProfile
 &deleteElementWithKey         ( const char* key,
                                 const char* applName = 0 ),

 &deleteElementWithApplication ( const char* applName = 0 );

#ifdef IC_PMWIN
static void
  deleteProfile                ( const char* profileName ),
  enableKeyMapping             ( bool        mapKey = true ),
  disableKeyMapping            ( );

static bool
  isKeyMappingEnabled          ( );
#endif

/*--------------------------------- Testing ----------------------------------*/
virtual bool
  containsApplication ( const char* applName ) const,
  containsKeyName     ( const char* key,
                        const char* applName = 0 );

class Cursor  {
public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( IProfile&   profile );
  Cursor ( IProfile&   profile,
           const char* applName );
virtual
 ~Cursor ( );

/*---------------------------- Profile Iteration -----------------------------*/
virtual bool
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( ),
  isValid       ( bool checkFile = false ) const;

virtual void
  invalidate    ( );

private:
/*-------------------------------- Private -----------------------------------*/
friend class IProfile;

#ifndef IC_WIN
void
  initCursor ( const IProfileHandle& hProfile,
               const char*           appName );
#endif

#ifdef IC_WIN
void
  initCursor ( const char*   profileName,
               const char*   appName );
#endif

unsigned
  pos;

IString
  strCl,
  applNameCl;

#ifndef IC_WIN
IProfileHandle
  hProfileCl;
#endif

IProfileCursorData
 *fCursorData;

}; // IProfile::Cursor


private:
/*------------------------------ Hidden Members ------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
#ifndef IC_WIN
  IProfile ( const IProfileHandle& profile );
#endif
#endif   // IC_MOTIF_FLAGNOP

/*--------------------------------- Private ----------------------------------*/
friend class IProfileData;

#ifndef IC_WIN
IProfileHandle
  hIni;
#endif

IString
  defApplName,
  profileName;

#ifndef IC_WIN
unsigned long
  length( const char* keyName,
          const char* applName = 0 ) const;
#endif

IProfileData
 *fProfileData;
}; // iProfile

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IPROFILE_
