// Revision: 47 1.4.1.4 source/ui/baseapp/iprocadr.hpp, application, ioc.v400, 980918  
#ifndef _IPROCADR_
#define _IPROCADR_
/*******************************************************************************
* FILE NAME: iprocadr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IProcedureAddress                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ireslib.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IProcedureAddressData;

#pragma enum(4)
#pragma pack(push,4)

#ifndef IC_MOTIF

template < class PtrToFnType >
class IProcedureAddress  {
public:
/*------------------------------- Constructors -------------------------------*/
  IProcedureAddress ( const char*          entryPoint,
                      const char*          dllName )
    : dll           ( new IDynamicLinkLibrary( dllName ) ),
      isOrdinal     ( false ),
      name          ( entryPoint ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( entryPoint ) );
  }

  IProcedureAddress ( const char*          entryPoint,
                      IDynamicLinkLibrary& aDLL )
    : dll           ( new IDynamicLinkLibrary( aDLL ) ),
      isOrdinal     ( false ),
      name          ( entryPoint ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( entryPoint ) );
  }

  IProcedureAddress ( unsigned long        ordinal,
                      const char*          dllName )
    : dll           ( new IDynamicLinkLibrary( dllName ) ),
      isOrdinal     ( true ),
      ord           ( ordinal ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( ordinal ) );
  }

  IProcedureAddress ( unsigned long        ordinal,
                      IDynamicLinkLibrary& aDLL )
    : dll           ( new IDynamicLinkLibrary( aDLL ) ),
      isOrdinal     ( true ),
      ord           ( ordinal ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( ordinal ) );
  }

  ~IProcedureAddress ( )
  {
    delete dll;
  }

/*--------------------------- Pointers to Functions --------------------------*/
  operator PtrToFnType ( ) const
  {
    return fnPtr;
  }

/*------------------------------- Memory Model -------------------------------*/
bool
  is32Bit ( ) const
  {
    if ( isOrdinal )
      return dll->isEntryPoint32Bit( ord );
    else
      return dll->isEntryPoint32Bit( name );
  }

private:
/*-------------------------------- Private -----------------------------------*/
PtrToFnType
 fnPtr;

IDynamicLinkLibrary
 *dll;

bool
 isOrdinal;

union {
  unsigned long
    ord;
  const char
   *name;
};

IProcedureAddressData
 *pProcAddrData;

}; // IProcedureAddress

#endif  // not IC_MOTIF

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IPROCADR_
