// Revision: 54 1.15.1.3 source/core/utils/iprimtyp.hpp, utilities, ioc.v400, 980918 
// iprimtyp.hpp
//
// Contains:    "Primitive" types and constants, including:
//
//    bool          - temporary until we get compiler support
//    ILongLong     - double-long type, typedefed to "long long" for IBMCPP
//
//
// Author:
//      Laura Werner and others
//
// COPYRIGHT:
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation 1992, 1997
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
//

#ifndef _IPRIMTYP_
#define _IPRIMTYP_

#ifndef _IBASEPL_H
#include <ibasepl.hpp>          // Need the base library
#endif

#pragma pack(push,4)
#pragma enum(4)

// Assorted types left over from CommonPoint
// TODO: Nuke these?
typedef unsigned long HashResult;
typedef long Fixed;                             // 16.16 Fixed Point
typedef unsigned long TokenID;

// TODO: These two types belong in a text header, not here!
typedef unsigned char PartialChar;
typedef unsigned short UniChar;

#pragma enum(pop)
#pragma pack(pop)

// Boolean types
#include <ilanglvl.hpp>

// ILongLong type, included here for CP compatibility
#include <ilonglng.hpp>

// Preprocessor symbol that handles DLL import/export portably.
#ifndef _EXPORT
  #if defined(__WINDOWS__)
    #define _EXPORT  _Export
  #else
    #define _EXPORT
  #endif
#endif
#ifndef _IMPORT
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define _IMPORT  _Import
  #else
    #define _IMPORT
  #endif
#endif

#endif // _IPRIMTYP_
