// ----------------------------------------------------------------------------
// FILE NAME: iprimlck.hpp
// 
// DESCRIPTION:
//
//  This header contains the declaration of the classes:
//      IPrimalLock
//
//  This class is used to support static/global initialization. All statics
//  and globals should be allocated as needed. Create a stack based IPrimalLock
//  object to protect this initialization.
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 92 1.5.1.3 source/core/base/iprimlck.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IPRIMLCK_
#define _IPRIMLCK_

#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IPrimalLock
{
    public :
        IPrimalLock();
        ~IPrimalLock();

    private :
        // These are hidden from use (implemented in ibasecc.cpp right now!)
        IPrimalLock(const IPrimalLock&);
        void operator=(const IPrimalLock&);
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
