// ----------------------------------------------------------------------------
// FILE NAME: iprcenv.hpp
//
// DESCRIPTION:
//
//  This module implements the IEnvironment class, which is kind of
//  specialized container of key/value string pairs as used by the
//  environments of Win32, OS/2, and AIX. It is used for querying,
//  modifying, transporting, etc... system and user environmental settings.
//  Its primary use is to pass environments to the IExternalProcess class,
//  which uses it to create the environment for spawned processes.
//
//  There are, of course, OpenClass collections which provide this kind of
//  functionality. However, their use is being deprecated so a very simple
//  singly linked list is implemented here. There are also layering reasons
//  not to use them here. The list class is IEnvData and is purely internal
//
//  Note that any nodes added after the call to first() will not show up in
//  in the iteration. first() must be called again to see them. If the node
//  currently being iterated (i.e. returned on the last next() call) is
//  removed, the iterator is moved forward.
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 23 1.11.1.2 source/core/base/iprcenv.hpp, oss, portapak
// ----------------------------------------------------------------------------

#ifndef _IPRCENV_
#define _IPRCENV_

#include <ibasepl.hpp>
#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
//  Used internally to track list of environment strings. It
//  tracks the key/value info and the next node pointer.
//
class   IEnvData;
class   IText;

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IEnvironment
{
    public :
                IEnvironment();
                IEnvironment(const bool copyCurrentEnv);
                IEnvironment(const IEnvironment& toCopy);
                ~IEnvironment();

        // Operators
        void    operator=(const IEnvironment& toAssign);

        // Getter methods
        unsigned long getCount() const;

        // List manipulation methods
        void    add(const IText& keyText, const IText& valueText);
        void    clear();
        bool    find(const IText& keyText, IText& valueText) const;
        IText   find(const IText& keyText) const;
        bool    first(IText& keyText, IText& valueText);
        bool    next(IText& keyText, IText& valueText);
        bool    remove(const IText& keyText);
        bool    update(const IText& keyText, const IText& newValue);


    private :
        // Internal for finding a key and its previous node
        IEnvData*   findKey(const IText& keyText, IEnvData*& prevNode) const;

        // Pointer to the head of the list of values
        IEnvData*   fHeadNode;

        // A node pointer for the interation methods
        IEnvData*   fIterNode;

        // The number of key/value pairs available
        unsigned long fCount;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iprcenv.inl>

#endif // _IPRCENV_
