// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// ipraglib.h - Library pragma macros.
// Revision: 59 1.8.1.6 source/core/base/ipraglib.h, build, portapak, 980122

#ifndef _IPRAGLIB_
#define _IPRAGLIB_

// The following define the components of a coded OpenClass library name.

#define PL_VACPP_PREFIX cpp

#if _IOC_VERSION_40_
    #define PL_LONG_PREFIX libvac
#else
    #define PL_LONG_PREFIX libcxx
#endif

#define         PL_SHARED_LIBRARY_TYPE_PREFIX i
#define         PL_STATIC_LIBRARY_TYPE_PREFIX s
#define         PL_RESOURCE_TYPE_PREFIX r
#define         PL_MESSAGE_TYPE_PREFIX i

#if defined(__IMPORTLIB__)
        #define PL_LIBRARY_TYPE_PREFIX PL_SHARED_LIBRARY_TYPE_PREFIX
#else
        #define PL_LIBRARY_TYPE_PREFIX PL_STATIC_LIBRARY_TYPE_PREFIX
#endif


        #define PL_LONG_NAMES 0
        #define PL_IMPORT_SUFFIX .lib
        #define PL_LIBRARY_SUFFIX .dll
        #define PL_STATIC_SUFFIX .lib
        #define PL_MESSAGE_LIBRARY_SUFFIX .msg
        #define PL_RESOURCE_LIBRARY_SUFFIX PL_LIBRARY_SUFFIX
























#if defined (_IOC_VERSION_40_) || (__IBMCPP__ >= 400)
#define PL_VERSION 40
#else
#define PL_VERSION 36
#endif

#define PL_CONCAT_3X(a1,a2,a3) a1##a2##a3
#define PL_CONCAT_3(a1,a2,a3) PL_CONCAT_3X(a1,a2,a3)

#define PL_CONCAT_4X(a1,a2,a3,a4) a1##a2##a3##a4
#define PL_CONCAT_4(a1,a2,a3,a4) PL_CONCAT_4X(a1,a2,a3,a4)

#define PL_CONCAT_5X(a1,a2,a3,a4,a5) a1##a2##a3##a4##a5
#define PL_CONCAT_5(a1,a2,a3,a4,a5) PL_CONCAT_5X(a1,a2,a3,a4,a5)

#define PL_STRINGX(arg) #arg
#define PL_STRING(arg) PL_STRINGX(arg)

// The following macro translates a library name code to an actual
// library name

#if defined(__NO_DEFAULT_LIBS__) && !defined(IC_DEFAULT_LIBS)
        #define OPENCLASS_LIBRARY_NAME(code) ""
#else
        #if PL_LONG_NAMES
                #define OPENCLASS_LIBRARY_NAME(code) PL_STRING(PL_CONCAT_3(PL_LONG_PREFIX,code,PL_IMPORT_SUFFIX))
        #else
                #define OPENCLASS_LIBRARY_NAME(code) PL_STRING(PL_CONCAT_5(PL_VACPP_PREFIX,code,PL_LIBRARY_TYPE_PREFIX,PL_VERSION,PL_IMPORT_SUFFIX))
        #endif
#endif

#if PL_LONG_NAMES
        #define OPENCLASS_DLL_NAME(code) PL_STRING(PL_CONCAT_3(PL_LONG_PREFIX,code,PL_LIBRARY_SUFFIX))
#else
        #define OPENCLASS_DLL_NAME(code) PL_STRING(PL_CONCAT_5(PL_VACPP_PREFIX,code,PL_SHARED_LIBRARY_TYPE_PREFIX,PL_VERSION,PL_LIBRARY_SUFFIX))
#endif

#if defined(__NO_DEFAULT_LIBS__) && !defined(IC_DEFAULT_LIBS)
        #define OPENCLASS_LIBRARY_NAME_2(code, code2) ""
#else
        #if PL_LONG_NAMES
                #define OPENCLASS_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_3(PL_LONG_PREFIX,code,PL_IMPORT_SUFFIX))

        #else
                #define OPENCLASS_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_5(PL_VACPP_PREFIX,code2,PL_LIBRARY_TYPE_PREFIX,PL_VERSION,PL_IMPORT_SUFFIX))
        #endif
#endif

#if PL_LONG_NAMES
        #define OPENCLASS_STATIC_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_3(PL_LONG_PREFIX,code,PL_STATIC_SUFFIX))
#else
        #define OPENCLASS_STATIC_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_5(PL_VACPP_PREFIX,code2,PL_LIBRARY_TYPE_PREFIX,PL_VERSION,PL_STATIC_SUFFIX))
#endif

#if PL_LONG_NAMES
        #define OPENCLASS_DLL_NAME_2(code, code2) PL_STRING(PL_CONCAT_3(PL_LONG_PREFIX,code,PL_LIBRARY_SUFFIX))
#else
        #define OPENCLASS_DLL_NAME_2(code, code2) PL_STRING(PL_CONCAT_5(PL_VACPP_PREFIX,code2,PL_SHARED_LIBRARY_TYPE_PREFIX,PL_VERSION,PL_LIBRARY_SUFFIX))
#endif

#if PL_LONG_NAMES
        #define OPENCLASS_RESOURCE_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_3(PL_LONG_PREFIX,code,PL_RESOURCE_LIBRARY_SUFFIX))
#else
        #define OPENCLASS_RESOURCE_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_5(PL_VACPP_PREFIX,code2,PL_RESOURCE_TYPE_PREFIX,PL_VERSION,PL_RESOURCE_LIBRARY_SUFFIX))
        #define OPENCLASS_RESOURCE_LIBRARY_NAME_NO_EXT(code, code2) PL_STRING(PL_CONCAT_4(PL_VACPP_PREFIX,code2,PL_RESOURCE_TYPE_PREFIX,PL_VERSION))
#endif

#if PL_LONG_NAMES
        #define OPENCLASS_MESSAGE_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_3(PL_LONG_PREFIX,code,PL_MESSAGE_LIBRARY_SUFFIX))
#else
        #define OPENCLASS_MESSAGE_LIBRARY_NAME_2(code, code2) PL_STRING(PL_CONCAT_5(PL_VACPP_PREFIX,code2,PL_MESSAGE_TYPE_PREFIX,PL_VERSION,PL_MESSAGE_LIBRARY_SUFFIX))
#endif

#endif // _IPRAGLIB_
