// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 15 1.5.1.4 source/core/collect/ipqutab.h, collection, ioc.v400, 980918 
#ifndef _IPQUTAB_
#define _IPQUTAB_

#include <ilanglvl.hpp>
#include <iapqu.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGPriorityQueueAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueAsTableCursor
                            (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsTable :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueueAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueAsTableTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGPriorityQueueAsTableCursor
            <Element, Key, ElementOps> Cursor;




           IGPriorityQueueAsTable
                            (INumber = 100);

           IGPriorityQueueAsTable
                            (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsTable <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGPriorityQueueAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueueAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueAsTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IPriorityQueueAsTable :
  public IGPriorityQueueAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueueAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IPriorityQueueAsTable <Element, Key> Self;

#define IPriorityQueueAsTableTypedef(Element, Key)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IPriorityQueueAsTable
                            (INumber = 100);

















protected:

           IPriorityQueueAsTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGPriorityQueueAsTable :
  public IGPriorityQueueAsTable
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueueAsTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGPriorityQueueAsTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueAsTableTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGPriorityQueueAsTable
                            (INumber = 100);

















protected:

           IVGPriorityQueueAsTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVPriorityQueueAsTable :
  public IVGPriorityQueueAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueueAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVPriorityQueueAsTable <Element, Key> Self;

#define IVPriorityQueueAsTableTypedef(Element, Key)\
  typedef  IVKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVPriorityQueueAsTable
                            (INumber = 100);

















protected:

           IVPriorityQueueAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ipqutab.inl>


#pragma info (restore)


#endif // _IPQUTAB_
