// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 11 1.5.1.4 source/core/collect/ipqulst.h, collection, ioc.v400, 980918 
#ifndef _IPQULST_
#define _IPQULST_

#include <ilanglvl.hpp>
#include <iapqu.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGPriorityQueueAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueAsListCursor
                            (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsListCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsList :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueueAsList <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueAsListTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGPriorityQueueAsListCursor
            <Element, Key, ElementOps> Cursor;




           IGPriorityQueueAsList
                            (INumber = 100);

           IGPriorityQueueAsList
                            (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsList <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGPriorityQueueAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueueAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueAsListCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IPriorityQueueAsList :
  public IGPriorityQueueAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueueAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IPriorityQueueAsList <Element, Key> Self;

#define IPriorityQueueAsListTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IPriorityQueueAsList
                            (INumber = 100);

















protected:

           IPriorityQueueAsList
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGPriorityQueueAsList :
  public IGPriorityQueueAsList
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueueAsList
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGPriorityQueueAsList
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueAsListTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGPriorityQueueAsList
                            (INumber = 100);

















protected:

           IVGPriorityQueueAsList
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVPriorityQueueAsList :
  public IVGPriorityQueueAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueueAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVPriorityQueueAsList <Element, Key> Self;

#define IVPriorityQueueAsListTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVPriorityQueueAsList
                            (INumber = 100);

















protected:

           IVPriorityQueueAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ipqulst.inl>


#pragma info (restore)


#endif // _IPQULST_
