// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 09 1.5.1.4 source/core/collect/ipqudil.h, collection, ioc.v400, 980918 
#ifndef _IPQUDIL_
#define _IPQUDIL_

#include <ilanglvl.hpp>
#include <iapqu.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksbdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGPriorityQueueAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueAsDilTableCursor
                            (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGPriorityQueueAsDilTable :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueueAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGPriorityQueueAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGPriorityQueueAsDilTable
                            (INumber = 100);

           IGPriorityQueueAsDilTable
                            (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueAsDilTable <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGPriorityQueueAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueueAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IPriorityQueueAsDilTable :
  public IGPriorityQueueAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueueAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IPriorityQueueAsDilTable <Element, Key> Self;

#define IPriorityQueueAsDilTableTypedef(Element, Key)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IPriorityQueueAsDilTable
                            (INumber = 100);

















protected:

           IPriorityQueueAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGPriorityQueueAsDilTable :
  public IGPriorityQueueAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueueAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGPriorityQueueAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGPriorityQueueAsDilTable
                            (INumber = 100);

















protected:

           IVGPriorityQueueAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVPriorityQueueAsDilTable :
  public IVGPriorityQueueAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueueAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVPriorityQueueAsDilTable <Element, Key> Self;

#define IVPriorityQueueAsDilTableTypedef(Element, Key)\
  typedef  IVKeySortedBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVPriorityQueueAsDilTable
                            (INumber = 100);

















protected:

           IVPriorityQueueAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ipqudil.inl>


#pragma info (restore)


#endif // _IPQUDIL_
