// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 07 1.5.1.4 source/core/collect/ipqu.h, collection, ioc.v400, 980918 
#ifndef _IPQU_
#define _IPQU_

#include <ilanglvl.hpp>
#include <iapqu.h>
#include <iicksb.h>

#include <iivksb.h>

#include <iiksblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGPriorityQueue;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGPriorityQueueCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef TYPENAME IGPriorityQueue
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGPriorityQueueCursor
                            (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueueCursor <Element, Key, ElementOps>&
           operator=        (IGPriorityQueueCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGPriorityQueueCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGPriorityQueue :
  public IAPriorityQueue <Element, Key> {
protected:

  typedef  IGPriorityQueue <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGPriorityQueueTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGPriorityQueueTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

  typedef  IGPriorityQueueCursor
            <Element, Key, ElementOps> Cursor;




           IGPriorityQueue
                            (INumber = 100);

           IGPriorityQueue
                            (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);

  IGPriorityQueue <Element, Key, ElementOps>&
           operator=        (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGPriorityQueue
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGPriorityQueue
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGPriorityQueueCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IPriorityQueue :
  public IGPriorityQueue
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGPriorityQueue
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IPriorityQueue <Element, Key> Self;

#define IPriorityQueueTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IPriorityQueue
                            (INumber = 100);

















protected:

           IPriorityQueue
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGPriorityQueue :
  public IGPriorityQueue
          <Element, Key, ElementOps > {

  typedef  IVGPriorityQueue
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGPriorityQueue
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGPriorityQueueTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGPriorityQueueTypedef (Element, Key, ElementOps);

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVGPriorityQueue
                            (INumber = 100);

















protected:

           IVGPriorityQueue
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVPriorityQueue :
  public IVGPriorityQueue
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGPriorityQueue
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVPriorityQueue <Element, Key> Self;

#define IVPriorityQueueTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef IRestrictedAccessCollectionGuard<Element> Guard;

           IVPriorityQueue
                            (INumber = 100);

















protected:

           IVPriorityQueue
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ipqu.inl>


#pragma info (restore)


#endif // _IPQU_
