// Revision: 45 1.10.1.8 source/ui/baseapp/ipopmenu.hpp, menu, ioc.v400, 980918 
#ifndef _IPOPMENU_
#define _IPOPMENU_
/*******************************************************************************
* FILE NAME: ipopmenu.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IPopUpMenu                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <imenu.hpp>
#include <imousevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPoint;
class IResourceId;
class IWindow;
class IPopUpMenuData;

#pragma enum(4)
#pragma pack(push,4)

class IPopUpMenu : public IMenu {
typedef IMenu
 Inherited;
public:

//------------------- General-Use Enums, Typedefs and Statics -----------------
enum ETrackButton { kLeftButton, kRightButton, kNoTracking };

/*------------------------------- Constructors -------------------------------*/
  IPopUpMenu ( IWindow*           owner,
               unsigned long      menuWindowId,
               const Style&       style = defaultStyle());

  IPopUpMenu ( const IResourceId& menuResId,
               IWindow*           owner );
virtual
 ~IPopUpMenu ( );

/*-------------------------------- Visibility --------------------------------*/
virtual IPopUpMenu
 &show ( const IPoint& atLocation, ETrackButton trackButton = kNoTracking );

/*----------------------------- Object Deletion ------------------------------*/
void
  setAutoDeleteObject  ( bool autoDelete = true );

bool
  isAutoDeleteObject   ( ) const;

#ifdef IC_MOTIF
virtual unsigned long
  id() const;
#endif

private:

/*---------------------- Event-Handling Implementation -----------------------*/
#ifdef IC_MOTIF
virtual void
  registerCallbacks   ( ),
  unregisterCallbacks ( );
#endif  //IC_MOTIF

/*------------------------------ Hidden Members ------------------------------*/
  IPopUpMenu ( const IPopUpMenu& menu );
IPopUpMenu
 &operator=  ( const IPopUpMenu& menu );
virtual IMenu
 &show       ( bool           showMenu = true );

/*--------------------------------- Private ----------------------------------*/
IPopUpMenuData
 *fPopUpMenuData;
#ifdef IC_WIN
bool
  fAutoDeleteObject;
#endif

}; // IPopUpMenu


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ipopmenu.inl>

#endif  /* _IPOPMENU_ */
