#ifndef _IPERFSET_
#define _IPERFSET_
/*----------------------------------------------------------------------------*/
/* FILE NAME: iperfset.hpp                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the classes:                                              */
/*     IPerformanceSettings                                                   */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   5645-001                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB IPerformanceSettings {
public:

/*--------------------------- Performance Settings ---------------------------*/
enum Setting {
  singleThreaded        = 1,
  singleThreadedGUI     = 2,
  validateWindowHandle  = 8,
  dynamicToolBarButtons = 16
};
static void
  enableSetting  ( Setting setting, bool enable = true ),
  disableSetting ( Setting setting );

static bool
  isSettingEnabled ( Setting setting );

private:
static unsigned long
  IC_IMPORTB fgSettings;

}; // IPerformanceSettings

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iperfset.inl>

#endif // _IPERFSET_
