// ----------------------------------------------------------------------------
//  FILE: ipathnam.hpp
//
//  Classes for parsing and manipulating file system path names
//
//  IPathName           - Portably stores and manipulates file system paths
//  IUnixPathNameParser - Convert Unix-style path strings to/from IPathName
//  IWin32PathNameParser- Convert Win32-style path strings to/from IPathName
//
//  COPYRIGHT:
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation 1997
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 72 1.18.1.3 source/core/filesys/ipathnam.hpp, filesystem, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IPATHNAM_
#define _IPATHNAM_

#include <ilanglvl.hpp>
#include <ifilesys.hpp>
#include <icmpdnam.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IPathName : public ICompoundName 
{
    StreamableDeclarationsMacro(IPathName);
public:
    IPathName();
    IPathName(const IPathName& copyMe);
    IPathName(const ICompoundName& downcast);
                        
    IPathName(const IHostPathName& path, const ICompoundNameParser& aParser = defaultParser());

    IPathName(  const IDirectory& startHere,
                const IHostPathName& partialPath,
                const ICompoundNameParser& aParser = defaultParser());

    IPathName(const IDirectory& startHere, const IPathName& partialPath);

    IPathName& operator=(const IPathName& copyMe);

    virtual ~IPathName ();

    static const ICompoundNameParser& defaultParser();

protected:
    // Streaming...
    virtual void writeToStream(IDataStream& towhere) const;
    virtual void readFromStream(IDataStream& fromwhere);
};


class IUnixPathNameParser : public ICompoundNameParser 
{
public:
    IUnixPathNameParser();
    IUnixPathNameParser(const IUnixPathNameParser& copyMe);
    IUnixPathNameParser& operator=(const IUnixPathNameParser& copyMe);
    virtual ~IUnixPathNameParser();
    
    virtual ICompoundName parseName(const IHostPathName&) const;
    virtual IHostPathName formatName(const ICompoundName&) const;

    virtual UniChar separator() const;

private:
    // Internal functions and data...
    enum
    {
        kUnixPathSeparator = '/'
    };

#if !IC_RTTI_ENABLED
    // For type identification.  Will go away when real RTTI is available.
    static const IParserType kType;
    virtual IParserType typeOf() const;
#endif // IC_RTTI_ENABLED
};


class IWin32PathNameParser : public ICompoundNameParser
{
public:
    IWin32PathNameParser();
    IWin32PathNameParser(const IWin32PathNameParser& copyMe);
    IWin32PathNameParser& operator=(const IWin32PathNameParser& copyMe);
    virtual ~IWin32PathNameParser();
    
    virtual ICompoundName parseName (const IHostPathName&) const;
    virtual IHostPathName formatName (const ICompoundName&) const;
                                                                        
    virtual UniChar separator() const;

private:
// Internal functions and data...
#if !IC_RTTI_ENABLED
    // For type identification.  Will go away when real RTTI is available.
    static const IParserType kType;
    virtual IParserType typeOf() const;
#endif // IC_RTTI_ENABLED
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
