// Revision: 39 1.6.1.3 source/ui/baseapp/ipainhdr.hpp, genhdr, ioc.v400, 980918 
#ifndef _IPAINHDR_
#define _IPAINHDR_
/*******************************************************************************
* FILE NAME: ipainhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPaintHandler                                                            *
*     IPaintConnectionTo                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ipainevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IPaintHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~IPaintHandler ( );

protected:
/*------------------------------- Constructors -------------------------------*/
  IPaintHandler ( );

/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  paintWindow ( IPaintEvent& event ) = 0;
}; // IPaintHandler

#pragma info(nocpy)

template <class ATarget>
class IPaintConnectionTo : public IPaintHandler {
typedef IPaintHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef bool  (ATarget::* MemberFunction)( IPaintEvent& );

/*------------------------------- Constructors -------------------------------*/
  IPaintConnectionTo ( ATarget&       target,
                       MemberFunction memberFunction );
virtual
 ~IPaintConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  paintWindow ( IPaintEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
MemberFunction
  fConnectedMember;
};  // IPaintConnectionTo

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ipainhdr.c>

#pragma info(restore)

#endif /* _IPAINHDR_ */
