// Revision: 35 1.7.1.6 source/ui/baseapp/ipainevt.hpp, genhdr, ioc.v400, 980918 
#ifndef _IPAINEVT_
  #define _IPAINEVT_
/*******************************************************************************
* FILE NAME: ipainevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPaintEvent                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>
#include <ibcolor.hpp>
#include <ihandle.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
class IGraphicContext;
#endif // IC_OBSOLETE
class IGrafPort;

class IPoint;

#pragma enum(4)
#pragma pack(push,4)

class IPaintEvent : public IEvent {
typedef IEvent
  Inherited;

public:
/*--------------------------- Constructors -----------------------------------*/
  IPaintEvent ( const IEvent& event );
virtual
 ~IPaintEvent ( );

/*--------------------------------- Painting ---------------------------------*/
IPaintEvent
 &clearBackground ( const IColor&     background =
                                      IColor(IColor::kDesktopBgnd) ),
 &clearBackground ( const IRectangle& fillRectangle,
                    const IColor&     background =
                                      IColor(IColor::kDesktopBgnd) ),
 &drawText        ( const char*       text,
                    const IPoint&     atPoint,
                    const IColor&     textColor =
                                      IColor(IColor::kWindowStaticText) );

virtual IPresSpaceHandle
 presSpaceHandle ( );

#ifndef IC_MOTIF_FLAGNOP
IPaintEvent
 &setGraphicContext ( const IPresSpaceHandle& handle,
                      bool                 setClipRegion = true );
#endif

IPaintEvent
 &setGrafPort ( IGrafPort& context,
                bool       setClipRegion = true );

#ifdef IC_PMWIN
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
IPaintEvent
 &setGraphicContext ( const IGraphicContext&  context,
                      bool                 setClipRegion = true );
#endif // IC_OBSOLETE
#endif

IRectangle
  rect ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IPaintEvent
 &initializeGC();

IPresSpaceHandle
  hpsCl;
IRectangle
  rectCl;
bool
  setGC;
}; // IPaintEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

/*----------------------------- Inline Functions -----------------------------*/
#include <ipainevt.inl>

#endif /* _IPAINEVT_ */
