// Revision: 33 1.6 source/ui/baseapp/ipagehdr.hpp, notebook, ioc.v400, 980918 
#ifndef _IPAGEHDR_
#define _IPAGEHDR_
/*******************************************************************************
* FILE NAME: ipagehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPageHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ipageevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IEvent;
class INotebookDrawItemEvent;

#pragma enum(4)
#pragma pack(push,4)

class IPageHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageHandler  ( );

virtual
  ~IPageHandler ( );

protected:
/*----------------------------- Event Dispatching ----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  help     ( IPageHelpEvent&         event ),
  resize   ( IPageEvent&             event ),
  remove   ( IPageRemoveEvent&       event );

virtual bool
  drawTab  ( INotebookDrawItemEvent& event );

virtual bool
#ifndef IC_MOTIFWIN_FLAGNOP
  selectPending ( IPageSelectEvent&  event ),
#endif
  select        ( IPageSelectEvent&  event );
}; // IPageHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IPAGEHDR_ */
