// Revision: 31 1.5 source/ui/baseapp/ipageevt.hpp, notebook, ioc.v400, 980918 
#ifndef _IPAGEEVT_
#define _IPAGEEVT_
/*******************************************************************************
* FILE NAME: ipageevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPageEvent                                                               *
*     IPageRemoveEvent                                                         *
*     IPageHelpEvent                                                           *
*     IPageSelectEvent                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ictlevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBitmapHandle;
class IHelpWindow;
class INotebook;
class IWindow;
class IPageHandle;

#pragma enum(4)
#pragma pack(push,4)


class IPageEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageEvent ( const IEvent&        event        );
  IPageEvent ( const IControlEvent& controlEvent );
  IPageEvent ( const IPageEvent&    pageEvent );

virtual
  ~IPageEvent ( );

/*------------------------------ Page Information ----------------------------*/
virtual IPageHandle
  pageHandle ( ) const;

virtual INotebook
 *notebook   ( ) const;
}; // IPageEvent


#ifndef IC_MOTIF_FLAGNOP
class IPageRemoveEvent : public IPageEvent {
typedef IPageEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageRemoveEvent ( const IEvent&        event        );
  IPageRemoveEvent ( const IControlEvent& controlEvent );
  IPageRemoveEvent ( const IPageEvent&    pageEvent    );

virtual
  ~IPageRemoveEvent ( );

/*------------------------------ Page Information ----------------------------*/
IWindow
 *pageWindow ( ) const;

IBitmapHandle
  tabBitmap  ( ) const;

virtual INotebook
 *notebook   ( ) const;

private:
/*----------------------------- Hidden Members -------------------------------*/
virtual IPageHandle
  pageHandle ( ) const;
}; // IPageRemoveEvent


class IPageHelpEvent : public IPageEvent {
typedef IPageEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageHelpEvent ( const IEvent&        event        );
  IPageHelpEvent ( const IControlEvent& controlEvent );
  IPageHelpEvent ( const IPageEvent&    pageEvent    );

virtual
  ~IPageHelpEvent ( );

/*------------------------------ Help Information ----------------------------*/
IHelpWindow
 *helpWindow ( ) const;

/*------------------------------ Page Information ----------------------------*/
virtual IPageHandle
  pageHandle ( ) const;

virtual INotebook
 *notebook   ( ) const;
}; // IPageHelpEvent
#endif


class IPageSelectEvent : public IPageEvent {
typedef IPageEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageSelectEvent ( const IEvent&        event        );
  IPageSelectEvent ( const IControlEvent& controlEvent );
  IPageSelectEvent ( const IPageEvent&    pageEvent    );

virtual
  ~IPageSelectEvent ( );

/*------------------------------ Page Information ----------------------------*/
virtual IPageHandle
  pageHandle                 ( ) const;

virtual INotebook
 *notebook                   ( ) const;

IPageHandle
  previousSelectedPageHandle ( ) const;
}; // IPageSelectEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IPAGEEVT_ */
