// Revision: 26 1.7.1.3 source/ui/basectl/ioutlbox.hpp, staticctls, ioc.v400, 980918 
#ifndef _IOUTLBOX_
  #define _IOUTLBOX_
/*******************************************************************************
* FILE NAME: ioutlbox.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IOutlineBox                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISize;
class IWindowHandle;
class IColor;
class IPoint;
class IOutlineBoxData;

#pragma enum(4)
#pragma pack(push,4)

class IOutlineBox : public IControl  {
typedef IControl
  Inherited;
public:
class Style;
/*------------------------------ Constructors --------------------------------*/
  IOutlineBox  ( unsigned long     id,
                 IWindow*          parent,
                 IWindow*          owner,
                 const IRectangle& initial = IRectangle(),
                 const Style&      style = defaultStyle() );

#ifdef IC_PMWIN
  IOutlineBox  ( unsigned long     id,
                 IWindow*          parent );

  IOutlineBox  ( const IWindowHandle& handle);
#endif

virtual
 ~IOutlineBox  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF1(Style, IOutlineBox, IWindow);
                                  // style class definition
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU backgroundFrame,
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D,
#endif
  IC_IMPORTU foregroundFrame;

#ifndef IC_MOTIF_FLAGNOP
static const Style
  IC_IMPORTU halftoneFrame;
#endif  // IC_MOTIF_FLAGNOP

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*---------------------------- Outline Types ---------------------------------*/
enum OutlineType {
  foreground,
  background,
  halftone };

IOutlineBox
 &setOutlineType(const OutlineType& type);
OutlineType
  outlineType() const;

/*----------------------------- Color Members --------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IColor
  foregroundColor     ( ) const;
#endif //IC_WIN_FLAGNOP

#ifdef IC_MOTIF
virtual IOutlineBox
 &setForegroundColor (const IColor &color);
#endif // IC_MOTIF

#ifdef IC_PMWIN
/*------------------------------ Canvas Support ------------------------------*/
virtual IRectangle
  visibleRectangle   ( ) const;
#endif

protected:
/*---------------------------- Color Functions -------------------------------*/
#ifdef IC_MOTIF
virtual IOutlineBox
 &setColor         ( unsigned long colorArea,
                     const IColor& color );
#endif

private:
/*----------------------------- Hidden Members -------------------------------*/
  IOutlineBox  ( const IOutlineBox& outlineBox );
IOutlineBox
 &operator=    ( const IOutlineBox& outlineBox );

/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;

#ifdef IC_MOTIF
IOutlineBoxData
 *fOutlineBoxData;
#endif // IC_MOTIF

};  // class IOutlineBox

INESTEDBITFLAGCLASSFUNCS(Style, IOutlineBox)
                                  // global style functions

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  // _IOUTLBOX_
