// ----------------------------------------------------------------------------
// FILE NAME: iobslist.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IObserverList
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Material - Property of IBM
//   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.
//
// Revision: 49 1.5.1.5 source/core/base/iobslist.hpp, notification, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IOBSLIST_
#define _IOBSLIST_

#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IObserver;
class INotificationEvent;
class IObserverPointers;
class IObserverListData;

#pragma pack(push,4)
#pragma enum(4)

class IObserverList
{
public:
    // ---------------------------- Constructors ------------------------------
                            IObserverList();
    virtual                 ~IObserverList();

                            IObserverList(const IObserverList& obsList);

    IObserverList&          operator=(const IObserverList& obsList);

    // ------------------------- Observer Notification ------------------------
    IObserverList&          notifyObservers(const INotificationEvent& event);

    IObserverList&          notifyObserversAsync(const INotificationEvent& anEvent);

    // ---------------------- Observer Addition and Removal -------------------
    virtual bool            add(IObserver& observer, void* userData);

    virtual IObserverList&  remove(const IObserver& observer);
    virtual IObserverList&  removeAll();

    bool                    isEmpty() const;


private:
    // --------------------------------- Private ------------------------------
    void                    lockList();
    void                    unlockList();

    IObserverPointers*      fObserverPointers;
    unsigned long           fNotifyDepth;
    IObserverListData*      fObserverListData;

    friend class            IObserverListData;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IOBSLIST_
