// Revision: 29 1.7.1.3 source/ui/baseapp/iobjwin.hpp, frame, ioc.v400, 980918 
#ifndef _IOBJWIN_
#define _IOBJWIN_
/*******************************************************************************
* FILE NAME: iobjwin.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IObjectWindow                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <iwindow.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IObjectWindowData;

#pragma enum(4)
#pragma pack(push,4)

class IObjectWindow : public IWindow {
typedef IWindow
  Inherited;
public:

class Style;

/*------------------------------- Constructors -------------------------------*/
  IObjectWindow ( const IObjectWindow::Style& style = defaultStyle() );
virtual
 ~IObjectWindow ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0( Style, IObjectWindow );

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU boundToMessageQueue,
  IC_IMPORTU noStyle;

static Style
  defaultStyle  ();

static void
  setDefaultStyle ( const Style& style );

/*--------------------------------- Closing ----------------------------------*/
IObjectWindow
 &close ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IObjectWindow ( const IObjectWindow& window );
IObjectWindow
 &operator=     ( const IObjectWindow& window );

/*--------------------------------- Private ----------------------------------*/
IObjectWindowData
 *fObjectWindowData;

static Style
  fCurrentDefaultStyle;

}; // IObjectWindow

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IOBJWIN_ */
