#ifndef _INOTIFY_
#define _INOTIFY_
// ----------------------------------------------------------------------------
// FILE NAME: inotify.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     INotifier
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Material - Property of IBM
//   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.
//
// Revision: 43 1.7.1.4 source/core/base/inotify.hpp, notification, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#include <ibase.hpp>
#include <inotadr.hpp>
#include <ingthrd.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IInterest;
class INotifierAddress;
class IObserver;
class IObserverList;
class INotificationEvent;
class IEventData;

#pragma pack(push,4)
#pragma enum(4)

typedef const char* INotificationId;

class INotifier
{
public:
    // ---------------------------- Constructors ------------------------------
    INotifier();
    virtual ~INotifier();

    // ----------------------- Notification Members ---------------------------
    virtual INotifier& enableNotification(bool enable = true) = 0;
    virtual INotifier& disableNotification() = 0;

    virtual bool isEnabledForNotification() const = 0;

    // -------------------------- Observer Notification -----------------------
    virtual INotifier& notifyObservers(const INotificationEvent& event) = 0;
    virtual INotifier& notifyObserversAsync(const INotificationEvent& event);

    virtual INotifierAddress notifierAddress() const;

    const IThreadId& threadId() const;


    // ----------------------- Notification Event Descriptions ----------------
    static INotificationId const IC_IMPORTB allChangesId;
    static INotificationId const IC_IMPORTB deleteId;

protected:
    // ------------------------ Observer Addition and Removal -----------------
    virtual INotifier& addObserver(IObserver& observer, const IInterest& interest);
    virtual INotifier& removeObserver(IObserver& observer) = 0;
    virtual INotifier& removeObserver(IObserver& observer, const IInterest& interest);
    virtual INotifier& removeAllObservers() = 0;

    virtual IObserverList& observerList(const IInterest* anInterest = 0) const = 0;

    // ---------------------------- Observer Notification ---------------------
    virtual INotifier& notifyObservers(const INotificationId& id) = 0;

private:
    // --------------------------------- Private ------------------------------
    friend class IObserver;
    friend class IInterest;

    IThreadId fThreadId;

    // ----------------------- Obsolete Data and Functions ---------------------
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
    virtual INotifier& addObserver(IObserver& observer, const IEventData& userData) = 0;
#endif // IC_OBSOLETE
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
