#ifndef _INOTIFEV_
#define _INOTIFEV_

// ----------------------------------------------------------------------------
// FILE NAME: inotifev.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     INotificationEvent
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Material - Property of IBM
//   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.
//
// Revision: 41 1.9.1.4 source/core/base/inotifev.hpp, notification, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#include <ibase.hpp>
#include <inotify.hpp>
#include <ievtdata.hpp>
#include <iintrst.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class INotificationEventData;
class INotifierAddress;

#pragma pack(push,4)
#pragma enum(4)

class INotificationEvent
{
public:

/*----------------------------- Constructors ---------------------------------*/
  INotificationEvent( const IInterest& interest);
  INotificationEvent(INotifier& notifier, const INotificationId& identifier);

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  INotificationEvent  ( const INotificationId&   identifier,
                        INotifier&               notifier,
                        bool                  notifierAttrChanged=true,
                        const IEventData&        eventData=IEventData(),
                        const IEventData&        observerData=IEventData() );
#endif // IC_OBSOLETE

  INotificationEvent  ( const INotificationEvent& event );

INotificationEvent
 &operator=           ( const INotificationEvent& event );

  virtual const IInterest&          interest() const;

  virtual ~INotificationEvent ( );

  virtual INotificationEvent* clone() const;  //Polymorphic copy

#if (IC_OBSOLETE <= IC_OBSOLETE_3)
/*----------------------------- Event Attributes -----------------------------*/
INotificationEvent
 &setNotifierAttrChanged  ( bool notifierAttrchanged=true ),
 &setEventData            ( const IEventData& eventData ),
 &setObserverData         ( const IEventData& observerData );

bool
  hasNotifierAttrChanged  ( ) const;
IEventData
  eventData               ( ) const,
  observerData            ( ) const;

virtual INotifier
 &notifier                ( ) const;
#endif // IC_OBSOLETE

virtual INotificationId
  notificationId          ( ) const;

virtual INotifierAddress
 notifierAddress         ( ) const;

protected:
  INotificationEvent();

private:
/*--------------------------------- Private ----------------------------------*/
  IInterest*            fInterest;
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  INotifier*            fEvtNotifier;
  bool               fAttrChanged;
  IEventData            fEvtData;
  IEventData            fObsData;
  INotificationEventData *fExtendedNotificationData;
#endif // IC_OBSOLETE
}; //INotificationEvent

template <class AType>
class INotificationEventFor : public INotificationEvent
{
public:
   INotificationEventFor ( const IInterest& interest ,const AType&  data);
   INotificationEventFor ( const INotificationEventFor<AType>& event );

   INotificationEventFor<AType>&
                  operator= ( const INotificationEventFor<AType>& event );

  virtual ~INotificationEventFor ();
  virtual const IInterest&  interest() const;
  virtual INotifierAddress notifierAddress( ) const;
  virtual INotificationId  notificationId ( ) const;
  virtual INotificationEvent*  clone ( ) const;

   const AType& eventData() const;


private:
  IInterest* fInterest;
  AType* fData;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

/*----------------------------- Inline Functions -----------------------------*/
#include <inotifev.inl>

#endif // _INOTIFEV_
