// Revision: 39 1.5.1.3 source/core/base/inotadr.hpp, notification, ioc.v400, 980918 
/*******************************************************************************
* FILE NAME: inotadr.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     INotifierAddress                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#ifndef _INOTADR_
#define _INOTADR_

#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class INotifier;

#pragma pack(push,4)
#pragma enum(4)

class INotifierAddress {
public:
        INotifierAddress();
        INotifierAddress(const INotifier* notifier);
        virtual ~INotifierAddress();

        bool operator==(const INotifierAddress& src ) const;
        bool operator!=(const INotifierAddress& src ) const;
        INotifierAddress & operator=(const INotifierAddress& src );

//Internal Use Only
public:
        INotifier& notifier();

private:

        const INotifier* fNotifier;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif// _INOTADR_
