// Revision: 27 1.5.1.3 source/core/base/ingapp.hpp, oss, ioc.v400, 980918  











#ifndef _INGAPP_
#define _INGAPP_
/*----------------------------------------------------------------------------*/
/* FILE NAME: ingapp.hpp                                                      */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Declaration of the class(es):                                            */
/*     INonGUIApplication                                                     */
/*     ICurrentNonGUIApplication                                              */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   5645-001                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <ibhandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct pib_s;

class IString;
class ICurrentNonGUIApplication;
class ICurrentNonGUIApplicationData;

#pragma enum(4)
#pragma pack(push,4)

class IC_EXPORTB INonGUIApplication
{
public:
/*-------------------------------- Diagnostics -------------------------------*/
virtual IString asString() const;
virtual IString asDebugInfo() const;

/*-------------------------- Process Information -----------------------------*/
static IProcessId currentPID();

virtual IProcessId id() const;

static ICurrentNonGUIApplication& current();

/*----------------------- Portable Priority Methods --------------------------*/
enum EProcessPriority
{
  belowNormal,
  normal,
  aboveNormal
};

virtual INonGUIApplication& setProcessPriority(const EProcessPriority newPrio);

/*----------------------- Deprecated Priority Methods ------------------------
  These are deprecated methods that are only supported on OS/2 for backwards
  compatibility. The enum is still visible because its still for now used
  with other classes (such as IExternalProcess.)
 ---------------------------------------------------------------------------- */
enum PriorityClass
{
    noChange,
    idleTime,
    regular,
    timeCritical,
    foregroundServer
};












protected:
/*------------------------------- Constructors -------------------------------*/
INonGUIApplication ( const IProcessId& id );
virtual ~INonGUIApplication ( );

/*------------------------ Setting Process Information -----------------------*/
virtual INonGUIApplication& setId(const IProcessId& id);

private:
/*------------------------------- Private ------------------------------------*/
static ICurrentNonGUIApplication* pCurrent;
IProcessId pid;
}; // INonGUIApplication


class IC_EXPORTB ICurrentNonGUIApplication : public INonGUIApplication
{
typedef INonGUIApplication Inherited;
public:
/*--------------------------------- Arguments --------------------------------*/
virtual int argc() const;

virtual IString argv(int argumentNumber) const;

virtual ICurrentNonGUIApplication
 &setArgs ( int               argc,
            const char* const argv[] );

/*--------------------------- Starting and Stopping --------------------------*/
virtual ICurrentNonGUIApplication& exit();

/*------------------------------- Diagnostics --------------------------------*/
virtual IString asDebugInfo() const;

protected:
/*------------------------------- Constructors -------------------------------*/
ICurrentNonGUIApplication ( );
virtual ~ICurrentNonGUIApplication ( );

/*---------------------------- Process Information ---------------------------*/




private:
/*-------------------------------- Private -----------------------------------*/
friend class INonGUIApplication;

int argCount;
IString* argValue;





ICurrentNonGUIApplicationData *pCurrentApplicationData;

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _INGAPP_
