// Revision: 25 1.5 source/ui/baseapp/inbdievt.hpp, notebook, ioc.v400, 980918 
#ifndef _INBDIEVT_
#define _INBDIEVT_
/*******************************************************************************
* FILE NAME: inbdievt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     INotebookDrawItemEvent                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <idievt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IPageHandle;

#pragma enum(4)
#pragma pack(push,4)

class INotebookDrawItemEvent : public IDrawItemEvent {
typedef IDrawItemEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  INotebookDrawItemEvent ( IEvent& event );

virtual
  INotebookDrawItemEvent :: ~INotebookDrawItemEvent ( );

/*----------------------------- Page Information -----------------------------*/
virtual IPageHandle
  page                   ( ) const;

virtual unsigned long
  itemId                 ( ) const;
}; // INotebookDrawItemEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _INBDIEVT_ */
