// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 02 1.5.1.4 source/core/collect/imwt.h, collection, ioc.v400, 980918 
#ifndef _IMWT_
#define _IMWT_

#include <ilanglvl.hpp>
#include <iamwt.h>
#include <iicmwt.h>

#include <iivmwt.h>

#include <iimwt.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <INumber numOfChildren, class Element, class ElementOps>
class IGMultiwayTree;

#pragma pack(push,4)
#pragma enum(4)

template <INumber numOfChildren, class Element, class ElementOps>
class IGMultiwayTreeCursor :
  public IElementTreeCursor <Element> {

  typedef  IElementTreeCursor <Element> Inherited;

  typedef TYPENAME IGMultiwayTree
            <numOfChildren, Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMultiwayTreeCursor
                            (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);

  IGMultiwayTreeCursor <numOfChildren, Element, ElementOps>&
           operator=        (IGMultiwayTreeCursor
                              <numOfChildren,
                               Element, ElementOps> const&);

protected:

           IGMultiwayTreeCursor
                            (ITreeCursorImpl*);

private:















};











































template <INumber numOfChildren, class Element, class ElementOps>
class IGMultiwayTree :
  public IAMultiwayTree <numOfChildren, Element> {
protected:

  typedef  IGMultiwayTree <numOfChildren, Element, ElementOps> Self;

  typedef  IMultiwayTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMultiwayTreeImpl
            <PureImplementation> Implementation;
#endif

#define IGMultiwayTreeTypedef(Element, ElementOps)\
  typedef  IMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGMultiwayTreeTypedef (Element, ElementOps);

public:

  typedef ITreeCollectionGuard<Element> Guard;

  typedef  IGMultiwayTreeCursor
            <numOfChildren, Element, ElementOps> Cursor;




           IGMultiwayTree
                            ();

           IGMultiwayTree
                            (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);

  IGMultiwayTree <numOfChildren, Element, ElementOps>&
           operator=        (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);



















protected:

           IGMultiwayTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);

private:

  friend
  class    IGMultiwayTreeCursor <numOfChildren, Element, ElementOps>;






















};

template <INumber numOfChildren, class Element>
class IMultiwayTree :
  public IGMultiwayTree
          <numOfChildren, Element, IStdOps <Element> > {

  typedef  IGMultiwayTree
            <numOfChildren, Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IMultiwayTree <numOfChildren, Element> Self;

#define IMultiwayTreeTypedef(Element)\
  typedef  IMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ITreeCollectionGuard<Element> Guard;

           IMultiwayTree
                            ();

















protected:

           IMultiwayTree
                              (PureImplementation&);

private:












};


template <INumber numOfChildren, class Element, class ElementOps>
class IVGMultiwayTree :
  public IGMultiwayTree
          <numOfChildren, Element, ElementOps > {

  typedef  IVGMultiwayTree
            <numOfChildren, Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGMultiwayTree
            <numOfChildren, Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVMultiwayTreeImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMultiwayTreeImpl
            <IVMultiwayTreeImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMultiwayTreeTypedef(Element, ElementOps)\
  typedef  IMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGMultiwayTreeTypedef (Element, ElementOps);

public:

  typedef ITreeCollectionGuard<Element> Guard;

           IVGMultiwayTree
                            ();

















protected:

           IVGMultiwayTree
                              (PureImplementation&);

private:












};

template <INumber numOfChildren, class Element>
class IVMultiwayTree :
  public IVGMultiwayTree
          <numOfChildren, Element, IStdOps <Element> > {

  typedef  IVGMultiwayTree
            <numOfChildren, Element,
             IStdOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVMultiwayTree <numOfChildren, Element> Self;

#define IVMultiwayTreeTypedef(Element)\
  typedef  IVMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ITreeCollectionGuard<Element> Guard;

           IVMultiwayTree
                            ();

















protected:

           IVMultiwayTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <imwt.inl>


#pragma info (restore)


#endif // _IMWT_
