// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 38 1.10.1.3 source/core/text/itext/imtabrl.hpp, text, ioc.v400, 980918  
#ifndef _IMTABRL_
#define _IMTABRL_

//#include "igbase2d.hpp"
//#include "igrtypes.hpp"
#include "itxtgrt.hpp"
#include "idatstrm.hpp"
#include <stddef.h>	//for size_t

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

//========================================================================================
// CLASS ITabStop
// A class representing a tab stop.
//========================================================================================
class ITabStop {
public:
	enum ETabStopKind { kLeft, kCenter, kRight, kDecimal, kAuto };

 						ITabStop(GCoord position, ETabStopKind type);
						ITabStop();
						ITabStop(const ITabStop& source);
    virtual				~ITabStop();

	ITabStop&			operator=(const ITabStop& source);

	virtual void		writeToStream(IDataStream& toWhere) const;
	virtual void		readFromStream(IDataStream& fromWhere);

    bool				operator==(const ITabStop& other) const;
    bool				operator!=(const ITabStop& other) const { return !((*this)==other);}

	ETabStopKind		type() const;
	GCoord			position() const;

private:
    ETabStopKind		fType;     // left, center, right, decimal
    GCoord			fPosition; // tab stop position from line origin.
};

//========================================================================================
// CLASS IMTabRuler
// Abstract class defining tab-ruler protocol.
//========================================================================================
class IMTabRuler {
public:
	virtual IMTabRuler* clone() const = 0;

	virtual size_t tabCount() const = 0;

	virtual ITabStop& operator[](size_t ndx) = 0;
	virtual const ITabStop& operator[](size_t ndx) const = 0;

    virtual ITabStop firstTab() const = 0;
    virtual ITabStop nextTab(GCoord position) const = 0;

    virtual GCoord autoSpacing() const = 0;

    bool operator==(const IMTabRuler& other) const;
};

//========================================================================================
// CLASS IStandardTabRuler
// Concrete class implementing the IMTabRuler protocol.
//========================================================================================
class IStandardTabRuler : public IMTabRuler {
public:
							IStandardTabRuler();
							IStandardTabRuler(GCoord autoSpacing);
							IStandardTabRuler(size_t tabCount, const ITabStop* tabs, GCoord autoSpacing);
							IStandardTabRuler(const IMTabRuler& ruler);

	virtual					~IStandardTabRuler();

	virtual IMTabRuler* 	clone() const;

	virtual size_t			tabCount() const;

	virtual ITabStop&		operator[](size_t ndx);
	virtual const ITabStop&	operator[](size_t ndx) const;

	virtual ITabStop		firstTab() const;
	virtual ITabStop		nextTab(GCoord position) const;

	virtual GCoord		autoSpacing() const;

	virtual bool			contains(const ITabStop& tabToTest) const;

	virtual void			addTab(const ITabStop& tabToAdd);
	virtual void			removeTab(GCoord position);
	virtual void			moveTab(GCoord fromPosition, GCoord toPosition);



	/** Debugging. */

//	static bool				rulerContainsTab(const IMTabRuler& ruler, const ITabStop& tabToTest);


//	static IMTabRuler*		addTabToRuler(const IMTabRuler& ruler, const ITabStop& tabToAdd);


//	static IMTabRuler*		removeTabFromRuler(const IMTabRuler& ruler, GCoord position);


//	static IMTabRuler*		moveTabOnRuler(const IMTabRuler& ruler, GCoord fromPosition, GCoord toPosition);


private:
	size_t					fTabCount;
	ITabStop*				fTabs;
	GCoord				fAutoSpacing; // every 1/2 inch.
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IMTABRL_
