// ----------------------------------------------------------------------------
//  FILE: imstrmbl.hpp
//
//  Defines the IMStreamable class, as well as classes for RRDC.
//
//  COPYRIGHT:
//   IBM Open Class Library
//   (C) Copyright International Business Machines Corporation,  1997
//   Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 46 1.17.1.4 source/core/streams/imstrmbl.hpp, oss, ioc.v400, 980918 
// ----------------------------------------------------------------------------

#ifndef _IMSTRMBL_
#define _IMSTRMBL_

#include <iprimtyp.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
// external class declarations.
//
class IDataStream;
class ITypeRepresentation;

#pragma pack(push,4)
#pragma enum(4)

class IMStreamable
{
public:
        virtual ~IMStreamable();

        virtual const ITypeRepresentation&      typeRepresentation() const = 0;

        //
        // these methods are called by the global streaming operators
        // and IStreamIO implementation classes.
        //
        void externalizeToStream(IDataStream& towhere) const;
        void internalizeFromStream(IDataStream& fromwhere);

protected:
        virtual void writeToStream(IDataStream& towhere) const = 0;
        virtual void readFromStream(IDataStream& fromwhere) = 0;

        IMStreamable();
        IMStreamable(const IMStreamable& other);
};

class IStreamOutFrame
{
public:
        IStreamOutFrame(IDataStream& aStream);
        ~IStreamOutFrame();

private:
        IStreamOutFrame();
        IStreamOutFrame(const IStreamOutFrame& other);

private:
        IDataStream*    fStream;
};


class IStreamInFrame
{
public:
        IStreamInFrame(IDataStream& aStream);
        ~IStreamInFrame();

        bool    atEnd();

private:
        IStreamInFrame();
        IStreamInFrame(const IStreamInFrame& other);

private:
        IDataStream*    fStream;
};

#pragma enum(pop)
#pragma pack(pop)

template <class AType> void writeObject(const AType* theObject, IDataStream& theStream);

template <class AType> void writeAliasedObject(const AType* theObject, IDataStream& theStream);

template <class AType> void readObject(AType*& theResult, IDataStream& theStream);

template <class AType> void readAliasedObject(AType*& theResult, IDataStream& theStream);

template <class AType> AType* copy(const AType& source);

template <class AType> AType* copyPointer(const AType* source);

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <imstrmbl.inl>

#endif
