// Revision: 05 1.5.1.3 source/ui/baseapp/imsgwin.hpp, views, ioc.v400, 980918 
#ifndef _IMSGWIN_
#define _IMSGWIN_
/*******************************************************************************
* FILE NAME: imsgwin.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMessageWindow                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1997             *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <iframe.hpp>
#include <icconst.h>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBitmapControl;
class IMessageWindowData;
class IPushButton;
class ITextControl;
class IText;

#pragma enum(4)
#pragma pack(push,4)

class IMessageWindow : public IFrameWindow {
typedef IFrameWindow
  Inherited;

public:

class Style;

/*------------------------------ Message Type --------------------------------*/
enum EMessageType {
  kUserDefinedMessage,
  kInformationMessage,
  kWarningMessage,
  kConfirmationMessage,
  kRetryMessage,
  kCatastrophicMessage
  };

virtual EMessageType
  messageType    ( ) const;
/*------------------------------ Constructors --------------------------------*/
  IMessageWindow ( unsigned long id = IC_DEFAULT_FRAME_ID,
                   IWindow*      owner = 0,
                   EMessageType  type = kInformationMessage,
                   const Style&  style = defaultStyle());

virtual
 ~IMessageWindow ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IMessageWindow, IFrameWindow, IWindow);
static const Style
  IC_IMPORTU deferClientCreation;

static void
  setDefaultStyle   ( const Style&    style );
static Style
  defaultStyle      ( );

/*------------------------------ Message Text --------------------------------*/
virtual IMessageWindow
 &setMessageText ( const IResourceId& message ),
 &setMessageText ( const IException&  exception ),
 &setMessageText ( const IText&       message );

IText
  messageText    ( ) const;

/*------------------------------- Message Id ---------------------------------*/
virtual IMessageWindow
 &setMessageId( const IResourceId& messageId ),
 &setMessageId( const IText&       messageId );

IText
  messageId   ( ) const;

/*--------------------------------- Buttons ----------------------------------*/
enum EButton {
  kEnter  = IC_ID_ENTER,
  kOk     = IC_ID_OK,
  kCancel = IC_ID_CANCEL,
  kAbort  = IC_ID_ABORT,
  kRetry  = IC_ID_RETRY,
  kIgnore = IC_ID_IGNORE,
  kYes    = IC_ID_YES,
  kNo     = IC_ID_NO,
  kHelp   = IC_ID_HELP
  };

virtual IPushButton
 *addButton ( EButton  buttonType,
              bool     isDefaultButton = false);

IPushButton
 *button    ( EButton  buttonType );

virtual IWindow
 *buttonParent ( );

/*--------------------------------- Images -----------------------------------*/
enum EImageType {
  kInformationImage,
  kQuestionImage,
  kWarningImage,
  kErrorImage
  };

virtual IMessageWindow
 &setMessageImage ( EImageType image ),
 &setMessageImage ( const IBitmapHandle& bitmapHandle );

/*------------------------------- Overrides ----------------------------------*/
virtual IMessageWindow
 &show            ( bool showWindow = true );

virtual unsigned long
  showModally     ( );

protected:
/*------------------------------ Customization -------------------------------*/
virtual IWindow
 *createClient        ( );

virtual IBitmapControl
 *createMessageImage  ( IWindow*           parentOwner );

virtual ITextControl
 *createMessageText   ( IWindow*           parentOwner );

virtual ITextControl
 *createMessageIdText ( IWindow*           parentOwner );

private:
/*----------------------------- Hidden Members -------------------------------*/
  IMessageWindow ( const IMessageWindow& messageWindow );
IMessageWindow
 &operator=   ( const IMessageWindow& messageWindow );

friend class IMessageWindowData;
/*------------------------------ Private Data --------------------------------*/
static Style
  currentDefaultStyle;

IMessageWindowData
 *fMessageWindowData;
}; /* IMessageWindow */

INESTEDBITFLAGCLASSFUNCS( Style, IMessageWindow )

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IMSGWIN_
