//-----------------------------------------------------------------------------
// FILE NAME: imsgtext.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IMsgtext
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 23  1.4.1.6  source/core/base/imsgtext.hpp, appsupport, ioc.v400, 980918  
//-----------------------------------------------------------------------------

#ifndef _IMSGTEXT_
#define _IMSGTEXT_

#include <ibasepl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IMessageText
{
public:
    // --------------------------------- Messages -----------------------------
    static char* messageFile();

    static void setMessageFile(const char* msgFileName);

    // ----------------------------- Constructors -----------------------------
    IMessageText(unsigned long messageId,
                 const char*   messageFileName = IMessageText::messageFile(),
                 const char*   textInsert1 = 0,
                 const char*   textInsert2 = 0,
                 const char*   textInsert3 = 0,
                 const char*   textInsert4 = 0,
                 const char*   textInsert5 = 0,
                 const char*   textInsert6 = 0,
                 const char*   textInsert7 = 0,
                 const char*   textInsert8 = 0,
                 const char*   textInsert9 = 0);
    
    IMessageText(const IMessageText& text);

    ~IMessageText();

    // -------------------------------- Accessors -----------------------------
    operator const char*() const;

    const char* text() const;

    IMessageText& setDefaultText(const char* text);
    IMessageText& operator=(const IMessageText& text);

    int successful() const;

private:
    // --------------------------------- Private ------------------------------
    static char *iocMessageFile;
    char *pClText;
    int bClSuccess;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IMSGTEXT_




