// Revision: 14 1.5.1.4 source/ui/baseapp/imousevt.hpp, userinput, ioc.v400, 980918 
#ifndef _IMOUSEVT_
#define _IMOUSEVT_
/*******************************************************************************
* FILE NAME: imousevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMouseEvent                                                              *
*     IMouseClickEvent                                                         *
*     IMousePointerEvent                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMousePointerEventData;
class IPoint;
class IPointerHandle;
class IWindowHandle;

#pragma enum(4)
#pragma pack(push,4)

class IMouseEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMouseEvent ( const IEvent& event );
virtual
 ~IMouseEvent ( );

/*--------------------------------- Position ---------------------------------*/
virtual IPoint
  mousePosition ( ) const;

/*---------------------------- Window Information ----------------------------*/
virtual IWindowHandle
  windowUnderPointer ( ) const;

/*------------------------------ Keyboard State ------------------------------*/
virtual bool
  isAltKeyDown     ( ) const,
  isCtrlKeyDown    ( ) const,
  isShiftKeyDown   ( ) const;
}; // IMouseEvent

class IMouseClickEvent : public IMouseEvent {
typedef IMouseEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMouseClickEvent ( const IEvent& event );
virtual
 ~IMouseClickEvent ( );

/*------------------------------- Mouse Button -------------------------------*/
enum MouseButton {
  button1,
  button2,
  button3,
  buttonChord
  };

virtual MouseButton
  mouseButton ( ) const;

/*------------------------------- Mouse Action -------------------------------*/
enum MouseAction {
  click,
  doubleClick,
  down,
  up
  };

virtual MouseAction
  mouseAction ( ) const;
}; // IMouseClickEvent

class IMousePointerEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMousePointerEvent ( const IEvent& event );
virtual
 ~IMousePointerEvent ( );

/*------------------------------ Mouse Pointer -------------------------------*/
IPointerHandle
  defaultMousePointer ( ) const,
  mousePointer        ( ) const;

IMousePointerEvent
  &setMousePointer    ( const IPointerHandle& mousePointer );

/*--------------------------------- Position ---------------------------------*/
IPoint
  mousePosition ( ) const;

/*---------------------------- Window Information ----------------------------*/
unsigned long
  windowId ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
IMousePointerEventData
 *fData;
}; // IMousePointerEvent

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMOUSEVT_ */
