// Revision: 11 1.7.1.7 source/ui/baseapp/imnitem.hpp, menu, ioc.v400, 980918 
#ifndef _IMNITEM_
#define _IMNITEM_
/*******************************************************************************
* FILE NAME: imnitem.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IMenuItem                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ibitflag.hpp>
#include <ihandle.hpp>
#include <istring.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMenu;
class IResourceId;
class ISubmenu;
class IMenuItemData;

#pragma enum(4)
#pragma pack(push,4)

class IMenuItem  {

public:
class Style;
class Attribute;
/*------------------------------- Constructors -------------------------------*/
  IMenuItem ( unsigned long    itemId,
              const Style&     style     = defaultStyle(),
              const Attribute& attribute = defaultAttribute() );

  IMenuItem ( const IMenuItem& menuItem );

IMenuItem
 &operator= ( const IMenuItem& menuItem );

 ~IMenuItem ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, IMenuItem);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU split,
  IC_IMPORTU drawItem,         //AJ F26433
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU splitWithSeparator,
#endif
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU buttonSeparator,
#endif
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU postSystemCommand,
  IC_IMPORTU postHelp,
#endif
  IC_IMPORTU separator,
  IC_IMPORTU unavailable,
  IC_IMPORTU noStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

#ifdef IC_PMWIN
virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;
#endif

static const unsigned long
  IC_IMPORTU atEnd;

/*-------------------------------- Attributes --------------------------------*/
INESTEDBITFLAGCLASSDEF0(Attribute, IMenuItem);

static const Attribute
  IC_IMPORTU classDefaultAttribute,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU noDismiss,
  IC_IMPORTU framed,
#endif
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU highlighted,
#endif
  IC_IMPORTU checked,
  IC_IMPORTU disabled,
  IC_IMPORTU noAttribute;

static Attribute
  defaultAttribute    ( );

static void
  setDefaultAttribute ( const Attribute& attribute );

/*------------------------------- Menu Layout --------------------------------*/
#ifdef IC_PM
enum LayoutType {
  normalLayout,
  splitLayout,
  splitWithSeparatorLayout,
  buttonSeparatorLayout
  };
#endif
#ifdef IC_WIN
enum LayoutType {
  normalLayout,
  splitLayout,
  splitWithSeparatorLayout
  };
#endif
#ifdef IC_MOTIF
enum LayoutType {
  normalLayout,
  splitLayout
  };
#endif

IMenuItem
  &setLayout ( LayoutType    value );
LayoutType
  layoutType ( ) const;
IMenuItem
  &setIndex  ( unsigned long index = atEnd );
unsigned long
  index      ( ) const;

/*------------------------------ Command Type --------------------------------*/
enum CommandType {
  command,
  systemCommand,
  helpCommand
  };
IMenuItem
 &setCommand  ( CommandType value );
CommandType
  commandType ( ) const;

/*-------------------------------- Properties --------------------------------*/
unsigned long
  id              ( ) const;

IMenuItem
  &setSeparator   ( ),
  &setSelectable  ( bool     selectable  = true );
IMenuItem
  &setDrawItem    ( bool     drawItem    = true );     //AJ F26433

bool
  isSelectable    ( ) const,
  isDrawItem      ( ) const,                          //AJ F26433
  isSeparator     ( ) const;

/*-------------------------------- Item State --------------------------------*/
IMenuItem
#ifndef IC_MOTIFWIN_FLAGNOP
  &setNoDismiss   ( bool noDismiss   = true ),
  &setFramed      ( bool framed      = true ),
#endif
#ifndef IC_MOTIF_FLAGNOP
  &setHighlighted ( bool highlighted = true ),
#endif
  &setChecked     ( bool checked     = true ),
  &setDisabled    ( bool disabled    = true );

bool
#ifndef IC_MOTIF_FLAGNOP
  isNoDismiss     ( ) const,
  isFramed        ( ) const,
  isHighlighted   ( ) const,
#endif  // IC_MOTIF_FLAGNOP
  isChecked       ( ) const,
  isDisabled      ( ) const;

/*---------------------------------- Label -----------------------------------*/
IMenuItem
  &setText   ( const char*          newText ),
  &setText   ( const IResourceId&   textResId ),
  &setBitmap ( const IBitmapHandle& menuItem ),
  &setBitmap ( const IResourceId&   bitmapResId ),
  &setBitmap ( unsigned long        bitmapResId );

IString
  text       ( ) const;

IBitmapHandle
  bitmap     ( ) const;

bool
  isText     ( ) const,
  isBitmap   ( ) const;

/*--------------------------------- Submenu ----------------------------------*/
IMenuItem
 &setSubmenuHandle ( const IMenuHandle& menuHandle );

IMenuHandle
  submenuHandle    ( ) const;

bool
  isSubmenu        ( ) const;

protected:

/*------------------------------ Implementation ------------------------------*/
IMenuItem
#ifndef IC_MOTIF_FLAGNOP
 &setExtendedStyle ( unsigned long newExtendedStyle ),
#endif
 &setStyle         ( unsigned long newStyle );

unsigned long
#ifndef IC_MOTIF_FLAGNOP
  extendedStyle    ( ) const,
#endif
  style            ( ) const;

IMenuItem
 &setAttribute     ( unsigned long newAttribute );
unsigned long
  attribute        ( ) const;

IMenuItem
 &setHelpId        ( unsigned long newHelpTopicId );
unsigned long
  helpId           ( ) const;

private:
/*-------------------------------- Private -----------------------------------*/
friend class IMenu;
#ifdef IC_MOTIF
friend class IMenuData;
friend class ISubmenu;
friend class IAixMenuImp;
friend class IMenuBld;
#endif
static Style
  currentDefaultStyle;
static Attribute
  currentDefaultAttribute;
IString
  strClItemText;
unsigned long
  iPosition;
unsigned long
  afStyle,
  afExtendedStyle,
  afAttribute,
  itemId,
  afHelpId;
#ifdef IC_MOTIF
IWindowHandle
  hwndSubmenu;
#endif
#ifndef IC_MOTIF
IMenuHandle
  hwndSubmenu;
#endif
IBitmapHandle
  hBitmapHandle;

static const Style
  IC_IMPORTU textItem,
  IC_IMPORTU bitmapItem,
  IC_IMPORTU submenu;

IMenuItemData
 *fMenuItemData;
}; // IMenuItem

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <imnitem.inl>

#endif  /* _IMNITEM_ */
