// Revision: 44 1.6.1.3 source/ui/baseapp/imngpres.hpp, datatype, ioc.v400, 980918 
#ifndef _IMNGPRES_
#define _IMNGPRES_
/*******************************************************************************
* FILE NAME: imngpres.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IManagedPresSpaceHandle                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/

#include <iuipl.hpp>
#include <i2dghand.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IWindow;
class IWindowHandle;

#pragma enum(4)
#pragma pack(push,4)

class IManagedPresSpaceHandle
{
public:
/*------------------------------- Constructors -------------------------------*/
  IManagedPresSpaceHandle(IWindow* window);
  IManagedPresSpaceHandle(const IWindowHandle& windowHandle);
 ~IManagedPresSpaceHandle();

  operator IPresSpaceHandle();

private:
  IWindow* fWindow;
  const IWindowHandle* fWindowHandle;
  IPresSpaceHandle fPresSpaceHandle;

  void releasePresSpace();

}; // IManagedPresSpaceHandle

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <imngpres.inl>

#endif // _IMNGPRES_
