// Revision: 09 1.4.1.4 source/ui/baseapp/imndihdr.hpp, menu, ioc.v400, 980918 
#ifndef _IMNDIHDR_
#define _IMNDIHDR_
/*******************************************************************************
* FILE NAME: imndihdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMenuDrawItemHandler                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ibitflag.hpp>
#include <imndievt.hpp>
#include <ipoint.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IMenuDrawItemHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuDrawItemHandler ( );
virtual
 ~IMenuDrawItemHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*------------------------------ Drawing Flags -------------------------------*/
INESTEDBITFLAGCLASSDEF0(DrawFlag, IMenuDrawItemHandler);
static const DrawFlag
  IC_IMPORTU drewChecked,
  IC_IMPORTU drewDisabled,
  IC_IMPORTU drewSelected;

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  setSize     ( IMenuDrawItemEvent& event,
                ISize&              newSize ),
  draw        ( IMenuDrawItemEvent& event,
                DrawFlag&           flag ),
  highlight   ( IMenuDrawItemEvent& event ),
  unhighlight ( IMenuDrawItemEvent& event );

private:
/*----------------------------- Private Functions ----------------------------*/
#ifdef IC_MOTIF
void
  drawArrowOnCascades(IMenuDrawItemEvent mndievt);
#endif
}; // IMenuDrawItemHandler

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMNDIHDR_ */
