// Revision: 57 1.3.1.3 source/multmed/immwave.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMWAVE_
   #define _IMMWAVE_
/*******************************************************************************
* FILE NAME:  immwav.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMWaveAudio                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immaud.hpp>
#include <istring.hpp>
#include <immabuf.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_WIN
class IMMDeviceSettings;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMWaveAudio : public IMMConfigurableAudio {
typedef IMMConfigurableAudio
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMWaveAudio  ( bool openNow = true,
                  unsigned long instance = 0,
                  bool openShareable = true );

virtual
  ~IMMWaveAudio ();

/*-------------------------------- Buffers -----------------------------------*/
#ifdef IC_PM
virtual unsigned long
  cutCopyBufferSize   (const IMMTime& from = IMMTime(),
                       const IMMTime& to   = IMMTime()) const;
virtual IMMWaveAudio
  &copyFromBuffer     (const IMMAudioBuffer& audioBuffer,
                       CallType call = wait),
  &copyToBuffer       (IMMAudioBuffer& audioBuffer,
                       const IMMTime& from = IMMTime(),
                       const IMMTime& to   = IMMTime(),
                       CallType call = wait) const,
  &cutToBuffer        (IMMAudioBuffer& audioBuffer,
                       const IMMTime& from = IMMTime(),
                       const IMMTime& to   = IMMTime(),
                       CallType call = wait),
  &pasteFromBuffer    (const IMMAudioBuffer& audioBuffer,
                       const IMMTime& from = IMMTime(),
                       const IMMTime& to   = IMMTime(),
                       CallType call = wait),
  &pasteToBuffer      (IMMAudioBuffer& audioBuffer,
                       CallType call = wait) const;

virtual bool
  supportsWaveFormat  (unsigned long bitsPerSample,
                       unsigned long samplesPerSecond,
                       unsigned long channels,
                       IMMAudioBuffer::Format format,
                       CallType call = wait) const;
#endif

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMWaveAudio ( unsigned long deviceIdentifier,
                 const IString& newAlias = IString() );

/*-------------------------------- Implementation ----------------------------*/
virtual bool
  isOpenStringValid (const IString& deviceName) const;

#ifdef IC_WIN
virtual IMMWaveAudio
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);
#endif

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMWaveAudio          ( const IMMWaveAudio& device );
IMMWaveAudio
 &operator=             ( const IMMWaveAudio& device );

#ifdef IC_WIN
IMMDeviceSettings
  *fDeviceSettings ;
#endif

}; //IMMWaveAudio

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMWAVE_ */
