// Revision: 55 1.3.1.3 source/multmed/immttime.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMTTIME_
   #define _IMMTTIME_
/*******************************************************************************
* FILE NAME:  immttime.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMTrackMinSecFrameTime                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immtime.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMAudioCDContents;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMTrackMinSecFrameTime : public IMMTime {
typedef IMMTime
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMTrackMinSecFrameTime  ( const IMMTrackMinSecFrameTime& time );
  IMMTrackMinSecFrameTime  ( IMMAudioCDContents& contents,
                             unsigned long value );
  IMMTrackMinSecFrameTime  ( IMMAudioCDContents& contents,
                             unsigned long track,
                             unsigned long minutes,
                             unsigned long seconds,
                             unsigned long frames);
virtual
  ~IMMTrackMinSecFrameTime ();

IMMTrackMinSecFrameTime
  &operator =  (const IMMTrackMinSecFrameTime& time);

/*-------------------------- Conversions -------------------------------------*/
virtual operator unsigned long () const;

/*-------------------------- Operators ---------------------------------------*/
IMMTrackMinSecFrameTime
  &operator += (const IMMTime& time),
  &operator -= (const IMMTime& time);

IMMTrackMinSecFrameTime
  operator +   (const IMMTime& time),
  operator -   (const IMMTime& time);

/*-------------------------- Diagnostics -------------------------------------*/
virtual IString
  asString    () const;

/*-------------------------- Attributes --------------------------------------*/
virtual unsigned long
  frames       () const,
  minutes      () const,
  seconds      () const,
  track        () const;

private:
/*--------------------------------- Private ----------------------------------*/
IMMTime
  fStart,
  fEnd;
unsigned long
  fTrackMinSecFrame;
};  // IMMTrackMinSecFrameTime

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMTTIME_ */
