// Revision: 50 1.4.1.3 source/multmed/immspeed.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMSPEED_
   #define _IMMSPEED_
/*******************************************************************************
* FILE NAME:  immspeed.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMSpeed                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMSpeed  {
public:
enum Format
{
  percentage      = 3,
  framesPerSecond
};

/*----------------------------- Constructors ---------------------------------*/
  IMMSpeed  ( unsigned long percent = 100 );
  IMMSpeed  ( Format format,
              unsigned long speed );
virtual
  ~IMMSpeed ();

/*-------------------------------- Format ------------------------------------*/
Format
  format () const;
virtual unsigned long
  speed  () const;

private:
/*--------------------------------- Private ----------------------------------*/
// Explicit copy CTOR, to avoid default inlining by compiler.
//IMMSpeed (const IMMSpeed& speed);

Format
  fFormat;
unsigned long
  fSpeed;
}; // IMMSpeed

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMSPEED_ */
