// Revision: 48 1.3.1.3 source/multmed/immsequ.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMSEQU_
   #define _IMMSEQU_
/*******************************************************************************
* FILE NAME:  immsequ.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMSequencer                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immfilem.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_WIN
class IMMDeviceSettings;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMSequencer : public IMMFileMedia {
typedef IMMFileMedia
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMSequencer  ( bool openNow = true,
                  unsigned long instance = 0,
                  bool openShareable = true );
virtual
  ~IMMSequencer ();

#ifdef IC_WIN
/*----------------------------- Audio Overrides -----------------------------*/
virtual IMMSequencer
  &setVolume   (unsigned long volume,
                AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait);
virtual unsigned long
  volume       (AudioChannel channel = left,
                CallType call = wait) const;
virtual IMMSequencer
  &resume      (bool resume = true, CallType call = wait);
#endif

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMSequencer(unsigned long deviceIdentifier,
               const IString& newAlias = IString());

/*-------------------------------- Implementation ----------------------------*/
virtual bool
  isOpenStringValid(const IString& deviceName) const;

#ifdef IC_WIN
virtual IMMSequencer
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);
#endif

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMSequencer          ( const IMMSequencer& device );
IMMSequencer
 &operator=             ( const IMMSequencer& device );

#ifdef IC_WIN
IMMDeviceSettings
  *fDeviceSettings ;
#endif

}; // IMMSequencer

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMSEQU_ */
