// Revision: 45 1.4.1.3 source/multmed/immremhd.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMREMHD_
   #define _IMMREMHD_
/*******************************************************************************
* FILE NAME: immremhd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMRemovableMediaHandler                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immdvhdr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ITimer;
class IMMRemovableMedia;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMRemovableMediaHandler : public IMMDeviceHandler {
typedef IMMDeviceHandler
  Inherited;
public:

/*----------------------------- Constructors ---------------------------------*/
  IMMRemovableMediaHandler();
virtual
  ~IMMRemovableMediaHandler();

/*-------------------------------- Media Loading -----------------------------*/
virtual IMMRemovableMediaHandler
  &mediaLoaded    (),
  &mediaUnloaded  ();

/*---------------------------- Device Attachment -----------------------------*/
virtual IMMRemovableMediaHandler
 &handleEventsFor ( IMMRemovableMedia* device ),
 &stopHandlingEventsFor ( IMMRemovableMedia* device );
/*-------------------------------- Event Processing --------------------------*/
virtual bool
  passDevice      (const IMMPassDeviceEvent& event);

protected:
/*-------------------------------- Event Dispatching -------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
// Explicit copy CTOR, to avoid default inlining by compiler.
IMMRemovableMediaHandler  (const IMMRemovableMediaHandler&);

/*----------------------------- Hidden Functions -----------------------------*/
virtual IMMRemovableMediaHandler
 &handleEventsFor( IWindow* window ),
 &handleEventsFor ( IMMDevice* device ),
 &stopHandlingEventsFor ( IWindow* window ),
 &stopHandlingEventsFor ( IMMDevice* device );

}; // IMMRemovableMediaHandler

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMREMHD_ */
