// Revision: 43 1.4.1.3 source/multmed/immremed.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMREMED_
   #define _IMMREMED_
/*******************************************************************************
* FILE NAME:  immremed.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMRemovableMedia                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immplayd.hpp>
#include <istring.hpp>
#include <inotify.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMRemovableMediaHandler;
class IMMRemovableMediaNotifyHandler;
class IMMRemovableMediaData;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMRemovableMedia : public IMMPlayableDevice {
typedef IMMPlayableDevice
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IMMRemovableMedia();

/*-------------------------------- Door and Presence -------------------------*/
virtual IMMRemovableMedia
  &closeDoor     (CallType call = wait),
#ifdef IC_PM
  &lockDoor      (bool lock = true, CallType call = wait),
  &unlockDoor    (CallType call = wait),
#endif  // IC_PM
  &openDoor      (bool open = true, CallType call = wait);

bool
  isMediaPresent (CallType call = wait) const;


/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTM mediaLoadedId;

/*----------------------- Observer Notification ------------------------------*/
virtual IMMRemovableMedia
 &enableNotification (bool enabled = true);

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMRemovableMedia (const IString& deviceName,
                      bool openNow,
                      unsigned long instance,
                      bool openShareable);

  IMMRemovableMedia (unsigned long deviceIdentifier,
                      const IString& newAlias = IString());

/*------------------- Observer Notification Implementation -------------------*/
IMMRemovableMedia
 &setNotificationHandler ( IMMRemovableMediaNotifyHandler* notifyHandler );

IMMRemovableMediaNotifyHandler
 *notificationHandler    ( ) const;


private:
/*--------------------------------- Private ----------------------------------*/
// Explicit copy CTOR, to avoid default inlining by compiler.
IMMRemovableMedia  (const IMMRemovableMedia& device);

friend class IMMRemovableMediaHandler;

IMMRemovableMedia                         //aj: very platform-specific, private hides them better than protected
  &startCheckMediaTimer(),
  &stopCheckMediaTimer();
void                                      //aj
  checkMedia      (unsigned long timerId);

IMMRemovableMediaData
  *fRemovableMediaData;


}; // IMMRemvableMedia

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMREMED_ */
