// Revision: 40 1.3.1.3 source/multmed/immrecrd.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMRECRD_
   #define _IMMRECRD_
/*******************************************************************************
* FILE NAME:  immrecrd.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMRecordable                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immfilem.hpp>
#include <immtime.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_WIN
class IMMDeviceSettings;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMRecordable : public IMMFileMedia {
typedef IMMFileMedia
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IMMRecordable();

/*-------------------------------- Editing -----------------------------------*/
virtual IMMRecordable
  &copy            (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = wait) const,
  &cueForRecording (CallType call = nowait),
  &cut             (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = wait),
  &deleteSelection (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = wait),
  &paste           (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    bool convert = true,
                    CallType call = wait),
  &record          (bool insert = true,
                    const IMMTime& begin = IMMTime(),
                    const IMMTime& end   = IMMTime(),
                    bool resumeIfPaused = true,
                    CallType call = nowait),
#ifdef IC_PM
  &redo            (CallType call = wait),
  &undo            (CallType call = wait),
#endif
  &save            (CallType call = nowait),
  &saveAs          (const IString& filename, CallType call = nowait);

#ifdef IC_PM
bool
  canRedo          () const,
  canUndo          () const;
#endif

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMRecordable ( const IString& deviceName,
                  bool openNow,
                  unsigned long instance,
                  bool openShareable);

  IMMRecordable ( unsigned long deviceIdentifier,
                  const IString& newAlias = IString());

#ifdef IC_WIN
/*-------------------------------- Implementation ----------------------------*/
virtual IMMRecordable
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);
#endif

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMRecordable         ( const IMMRecordable& device );
IMMRecordable
 &operator=             ( const IMMRecordable& device );

#ifdef IC_WIN
IMMDeviceSettings
  *fDeviceSettings ;
#endif

}; // IMMRecordable

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMRECRD_ */
