// Revision: 38 1.3.1.3 source/multmed/immplypn.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMPLYPN_
   #define _IMMPLYPN_
/*******************************************************************************
* FILE NAME: immplypn.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMPlayerPanel                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <imcelcv.hpp>
#include <immplayd.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMPlayerPanelData;
class IMMPlayerPanelHandler;
class IAnimatedButton ;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMPlayerPanel : public IMultiCellCanvas {
typedef IMultiCellCanvas
  Inherited;
public:
/*------------------------- Constructors -------------------------------------*/
  IMMPlayerPanel  ( unsigned long         identifier,
                    IWindow*              parent,
                    IWindow*              owner,
                    unsigned long         deviceType = IMMDevice::other,
                    const IRectangle&     initial = IRectangle(),
                    const IMultiCellCanvas::Style& style =
                                    IMultiCellCanvas::defaultStyle() );

virtual
  ~IMMPlayerPanel ();

/*-------------------------------- Device ------------------------------------*/
IMMPlayableDevice*
  playableDevice     () const;
IMMPlayerPanel
  &setPlayableDevice (IMMPlayableDevice* device);
unsigned long
  deviceType         () const;

/*-------------------------------- Buttons -----------------------------------*/
IAnimatedButton
  *rewindButton       () const,
  *fastForwardButton  () const,
  *pauseButton        () const,
  *stopButton         () const,
  *playButton         () const,
  *stepForwardButton  () const,
  *stepBackwardButton () const;

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMPlayerPanel        ( const IMMPlayerPanel& panel );
IMMPlayerPanel
 &operator=             ( const IMMPlayerPanel& panel );

IMMPlayerPanelData
  *fPanelData;
}; // IMMPlayerPanel

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMPLYPN_ */
