// Revision: 36 1.3.1.3 source/multmed/immplyhd.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMPLYHD_
   #define _IMMPLYHD_
/*******************************************************************************
* FILE NAME:  immplyhd.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMPlayerPanelHandler                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <icmdhdr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IMMPlayerPanel;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMPlayerPanelHandler : public ICommandHandler {
typedef ICommandHandler
  Inherited;
public:
/*-------------------------- Constructors ------------------------------------*/
  IMMPlayerPanelHandler  ();
virtual
  ~IMMPlayerPanelHandler ();

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  command (ICommandEvent& event);

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  play               (const IMMPlayerPanel& panel),
  stop               (const IMMPlayerPanel& panel),
  pause              (const IMMPlayerPanel& panel),
  fastForward        (const IMMPlayerPanel& panel),
  rewind             (const IMMPlayerPanel& panel),
  stepForward        (const IMMPlayerPanel& panel),
  stepBackward       (const IMMPlayerPanel& panel);

}; // IMMPlayerPanelHandler

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMPLYHD_ */
