// Revision: 34 1.4.1.3 source/multmed/immplayd.hpp, multimedia, ioc.v400, 980918 
#ifndef _IMMPLAYD_
   #define _IMMPLAYD_
/*******************************************************************************
* FILE NAME: immplayd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMPlayableDevice                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <immdev.hpp>

#ifdef IC_WIN
#include <itimer.hpp>
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;

#ifdef IC_WIN
class IMMDeviceSettings;
#endif

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class IMMPlayableDevice : public IMMDevice {
typedef IMMDevice
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IMMPlayableDevice ();

/*----------------------------- Start and Stop -------------------------------*/
virtual IMMPlayableDevice
  &cueForPlayback       (CallType call = wait),
  &play                 (const IMMTime& from = IMMTime(),
                         const IMMTime& to   = IMMTime(),
                         bool resumeIfPaused = true,
                         CallType call = nowait),
  &stop                 (CallType call = wait);

/*----------------------------- Pause and Resume -----------------------------*/
virtual IMMPlayableDevice
  &pause                (CallType call = wait),
  &resume               (bool resume = true, CallType call = wait);

/*----------------------------- Seek -----------------------------------------*/
virtual IMMPlayableDevice
  &seek                 (const IMMTime& to, CallType call = wait),
  &seekToEnd            (CallType call = wait),
  &seekToStart          (CallType call = wait),
  &stepFrame            (unsigned long frames = 1, bool forward = true,
                         CallType call = wait);

/*----------------------------- Cue Points -----------------------------------*/
#ifdef IC_PM
virtual IMMPlayableDevice
  &removeCuePoint       (const IMMTime& time, CallType call = wait),
  &addCuePoint          (const IMMTime& time, CallType call = wait);
#endif

/*----------------------------- Notifications --------------------------------*/
virtual IMMPlayableDevice
  &stopPositionTracking (CallType call = wait),
  &startPositionTracking(const IMMTime& timeInterval, CallType call = wait);

unsigned long
  length                (CallType call = wait) const,
  position              (CallType call = wait) const;

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMPlayableDevice  (const IString& deviceOrFileName,
                      bool openNow = true,
                      unsigned long instance = 0,
                      bool openShareable = true);
  IMMPlayableDevice  (unsigned long deviceIdentifier,
                      const IString& newAlias = IString());

#ifdef IC_WIN
/*-------------------------------- Implementation ----------------------------*/
virtual IMMPlayableDevice
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (bool newRecordMode = false);
#endif

private:
/*--------------------------------- Private ----------------------------------*/
// Explicit copy CTOR, to avoid default inlining by compiler.
IMMPlayableDevice  (const IMMPlayableDevice&);

#ifdef IC_PM
void
  setCuePoint       (const IMMTime &time, bool on, CallType call);
#endif

void
  setPositionAdvise (const IMMTime &time, bool on, CallType call);

#ifdef IC_WIN
// use this to emulate the OS/2 MCI_SET_POSITION_ADVISE command
ITimer
  positionTimer ;
void
  positionTimerChange() ;
IMMDeviceSettings
  *fDeviceSettings ;
#endif
}; // IMMPlayableDevice

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IMMPLAYD_ */
