// Revision: 32 1.5.1.2 source/multmed/immpl.hpp, multimedia, ioc.v400, 980918 

/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   Licensed Material - Property of IBM                                                 *
*   (C) Copyright IBM Corp. 1996, 1997  All Rights Reserved.                            *
*                                                                                       *
*****************************************************************************************
*/
// immpl.hpp - Pragma Library definitions for multmed

#ifndef _IMMPL_
#define _IMMPL_

#ifndef IC_IMPORTM
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IC_IMPORTM  _Import
  #else
    #define IC_IMPORTM
  #endif
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef _IPRAGLIB_H
#include <ipraglib.h>
#endif

#if !defined(__NO_DEFAULT_LIBS__)
    #if !defined(__NO_MULTMED_LIB__)
        #if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
                    #pragma comment(lib, OPENCLASS_LIBRARY_NAME_2(multmed,om))
            #else                   // VAC
                    #pragma library(OPENCLASS_LIBRARY_NAME_2(multmed,om))
            #endif
        #elif defined(__OS2__)
                #pragma library(OPENCLASS_LIBRARY_NAME_2(multmed,om))
        #endif // platform
    #else
        // This will be seen in the context of building the library only.
        #if defined(__WINDOWS__)
            #if defined(_MSC_VER)   // MSVC
                #pragma comment(lib, "kernel32.lib")
                #pragma comment(lib, "user32.lib")
            #else                   // VAC
                #pragma library("kernel32.lib")
                #pragma library("user32.lib")
            #endif
        #elif defined(__OS2__)
            #pragma library("os2386.lib")
        #endif // __OS2__
    #endif // __NO_MULTMED_LIB__
#endif  // __NO_DEFAULT_LIBS__

#endif // _IMMPL_
